/*
 * Decompiled with CFR 0.152.
 */
package org.codemonkey.javareflection;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternalClassLoader
extends ClassLoader {
    private String basepath;
    protected final Map<String, Class<?>> classes = new HashMap();
    protected CompileException exception;

    public ExternalClassLoader() {
        super(ExternalClassLoader.class.getClassLoader());
    }

    @Override
    public final Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> c = this.classes.get(className);
        return c != null ? c : this.findClass(className);
    }

    @Override
    public final Class<?> findClass(String className) throws ClassNotFoundException {
        this.exception = null;
        try {
            this.checkForFile(this.basepath, className);
            Class<?> c = this.classes.get(className);
            if (c != null) {
                return c;
            }
            throw new ClassNotFoundException();
        }
        catch (ClassNotFoundException e) {
            Class<?> c = this.findSystemClass(className);
            this.classes.put(className, c);
            return c;
        }
        catch (IOException e) {
            this.exception = new CompileException(e.getMessage(), e);
            return null;
        }
        catch (CompileException e) {
            this.exception = e;
            return null;
        }
    }

    private void checkForFile(String classPath, String className) throws CompileException, IOException {
        String resource = className.replace("..", "||").replace('.', File.separatorChar).replace("||", "..");
        File javaSource = new File(classPath + File.separatorChar + resource + ".java");
        File javaClass = new File(classPath + File.separatorChar + resource + ".class");
        new File(this.basepath).getAbsolutePath();
        javaSource.getAbsolutePath();
        String absoluteClassPath = javaClass.getAbsolutePath();
        if (javaSource.exists()) {
            if (javaClass.exists()) {
                if (javaSource.lastModified() > javaClass.lastModified()) {
                    if (!javaClass.delete()) {
                        throw new CompileException("runtime compiler: unable to removed outdated .class file");
                    }
                    this.classes.remove(className);
                } else if (this.classes.get(className) == null) {
                    this.classes.put(className, this.loadClass(absoluteClassPath, className));
                }
            }
            if (!javaClass.exists()) {
                boolean status = false;
                switch (0) {
                    case 0: {
                        this.classes.put(className, this.loadClass(absoluteClassPath, className));
                        break;
                    }
                    case 1: {
                        throw new CompileException("runtime compiler: ERROR");
                    }
                    case 2: {
                        throw new CompileException("runtime compiler: CMDERR");
                    }
                    case 3: {
                        throw new CompileException("runtime compiler: SYSERR");
                    }
                    case 4: {
                        throw new CompileException("runtime compiler: ABNORMAL");
                    }
                    default: {
                        throw new CompileException("Compile status: Unknown exit status");
                    }
                }
            }
        }
    }

    private Class<?> loadClass(String classPath, String className) throws IOException {
        File f = new File(classPath);
        int size = (int)f.length();
        byte[] buff = new byte[size];
        DataInputStream dis = new DataInputStream(new FileInputStream(f));
        dis.readFully(buff);
        dis.close();
        return this.defineClass(className, buff, 0, buff.length, null);
    }

    public void setBasepath(String basepath) {
        this.basepath = basepath;
    }

    public String getBasepath() {
        return this.basepath;
    }

    public static class CompileException
    extends ScriptException {
        private static final long serialVersionUID = -7210219718456902667L;

        public CompileException(String reason) {
            super(reason);
        }

        public CompileException(String reason, Throwable cause) {
            super(reason + "\n\t" + cause.toString());
            this.setStackTrace(cause.getStackTrace());
        }
    }
}

