/*
 * Decompiled with CFR 0.152.
 */
package org.codemonkey.javareflection;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueConverter {
    static final List<Class<?>> COMMON_TYPES = Arrays.asList(String.class, Integer.class, Integer.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Long.class, Long.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Boolean.class, Boolean.TYPE, Character.class, Character.TYPE);
    static final List<Class<?>> PRIMITIVE_NUMBER_TYPES = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);

    public static boolean isCommonType(Class<?> c) {
        return COMMON_TYPES.contains(c);
    }

    private ValueConverter() {
    }

    public static List<Class<?>> collectCompatibleTypes(Class<?> c) {
        if (ValueConverter.isCommonType(c)) {
            return Collections.unmodifiableList(COMMON_TYPES);
        }
        return Arrays.asList(String.class);
    }

    public static Object[] convert(Object[] args, Class<?>[] targetTypes, boolean useOriginalValueWhenIncompatible) throws IncompatibleTypeException {
        if (args.length != targetTypes.length) {
            throw new IllegalStateException("number of target types should match the number of arguments");
        }
        Object[] convertedValues = new Object[args.length];
        for (int i = 0; i < targetTypes.length; ++i) {
            try {
                convertedValues[i] = ValueConverter.convert(args[i], targetTypes[i]);
                continue;
            }
            catch (IncompatibleTypeException e) {
                if (useOriginalValueWhenIncompatible) {
                    convertedValues[i] = args[i];
                    continue;
                }
                throw e;
            }
        }
        return convertedValues;
    }

    public static Object convert(Object value, Class<?> targetType) throws IncompatibleTypeException {
        if (value == null) {
            return null;
        }
        Class<?> valueType = value.getClass();
        if (targetType.isAssignableFrom(valueType)) {
            return value;
        }
        if (targetType.equals(String.class)) {
            return value.toString();
        }
        if (valueType.equals(String.class)) {
            return ValueConverter.convert((String)value, targetType);
        }
        if (Number.class.isAssignableFrom(valueType) || ValueConverter.isPrimitiveNumber(valueType)) {
            return ValueConverter.convert((Number)value, targetType);
        }
        if (valueType.equals(Boolean.class) || valueType.equals(Boolean.TYPE)) {
            return ValueConverter.convert((Boolean)value, targetType);
        }
        if (valueType.equals(Character.class) || valueType.equals(Character.TYPE)) {
            return ValueConverter.convert((Character)value, targetType);
        }
        throw new IncompatibleTypeException(value, valueType.toString(), targetType.toString());
    }

    public static Object convert(Number value, Class<?> targetType) throws IncompatibleTypeException {
        if (value == null) {
            return null;
        }
        if (targetType.equals(String.class)) {
            return value.toString();
        }
        if (targetType.equals(Integer.class) || targetType.equals(Integer.TYPE)) {
            return value.intValue();
        }
        if (targetType.equals(Boolean.class) || targetType.equals(Boolean.TYPE)) {
            return value.intValue() > 0;
        }
        if (targetType.equals(Float.class) || targetType.equals(Float.TYPE)) {
            return Float.valueOf(value.floatValue());
        }
        if (targetType.equals(Double.class) || targetType.equals(Double.TYPE)) {
            return value.doubleValue();
        }
        if (targetType.equals(Long.class) || targetType.equals(Long.TYPE)) {
            return value.longValue();
        }
        if (targetType.equals(Byte.class) || targetType.equals(Byte.TYPE)) {
            return value.byteValue();
        }
        if (targetType.equals(Short.class) || targetType.equals(Short.TYPE)) {
            return value.shortValue();
        }
        if (targetType.equals(Character.class) || targetType.equals(Character.TYPE)) {
            return Character.valueOf(Character.forDigit(value.intValue(), 10));
        }
        throw new IncompatibleTypeException(value, value.getClass().toString(), targetType.toString());
    }

    public static Object convert(Boolean value, Class<?> targetType) throws IncompatibleTypeException {
        if (value == null) {
            return null;
        }
        if (targetType.equals(Boolean.class) || targetType.equals(Boolean.TYPE)) {
            return value;
        }
        if (targetType.equals(String.class)) {
            return value.toString();
        }
        if (Number.class.isAssignableFrom(targetType) || ValueConverter.isPrimitiveNumber(targetType)) {
            return ValueConverter.convertNumber(value != false ? "1" : "0", targetType);
        }
        if (targetType.equals(Character.class) || targetType.equals(Character.TYPE)) {
            return Character.valueOf(value != false ? (char)'1' : '0');
        }
        throw new IncompatibleTypeException(value, Boolean.class.toString(), targetType.toString());
    }

    public static Object convert(Character value, Class<?> targetType) throws IncompatibleTypeException {
        if (value == null) {
            return null;
        }
        if (targetType.equals(String.class)) {
            return value.toString();
        }
        if (targetType.equals(Character.TYPE) || targetType.equals(Character.class)) {
            return value;
        }
        if (Number.class.isAssignableFrom(targetType) || ValueConverter.isPrimitiveNumber(targetType)) {
            return ValueConverter.convertNumber(String.valueOf(value), targetType);
        }
        if (targetType.equals(Boolean.class) || targetType.equals(Boolean.TYPE)) {
            if (value.equals(Character.valueOf('0'))) {
                return false;
            }
            if (value.equals(Character.valueOf('1'))) {
                return true;
            }
        }
        throw new IncompatibleTypeException(value, Character.class.toString(), targetType.toString());
    }

    public static Object convert(String value, Class<?> targetType) throws IncompatibleTypeException {
        if (value == null) {
            return null;
        }
        if (targetType.equals(String.class)) {
            return value;
        }
        if (targetType.isEnum()) {
            return ValueConverter.convertEnum(value, targetType);
        }
        if (value.length() > 0) {
            if (value.length() == 1) {
                if (targetType.equals(Character.class) || targetType.equals(Character.TYPE)) {
                    return Character.valueOf(value.charAt(0));
                }
                return ValueConverter.convert(Character.valueOf(value.charAt(0)), targetType);
            }
            if (Number.class.isAssignableFrom(targetType) || ValueConverter.isPrimitiveNumber(targetType)) {
                return ValueConverter.convertNumber(value, targetType);
            }
            if (targetType.equals(Boolean.class) || targetType.equals(Boolean.TYPE)) {
                if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("0")) {
                    return false;
                }
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1")) {
                    return true;
                }
            }
        }
        throw new IncompatibleTypeException(value, value.getClass().toString(), targetType.toString());
    }

    public static Object convertEnum(String value, Class<? extends Enum<?>> targetType) {
        if (value == null) {
            return null;
        }
        try {
            return targetType.getMethod("valueOf", String.class).invoke(null, value);
        }
        catch (IllegalArgumentException e) {
            throw new IncompatibleTypeException((Object)value, Enum.class.toString(), targetType.toString(), e);
        }
        catch (SecurityException e) {
            throw new IncompatibleTypeException((Object)value, Enum.class.toString(), targetType.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleTypeException((Object)value, Enum.class.toString(), targetType.toString(), e);
        }
        catch (InvocationTargetException e) {
            throw new IncompatibleTypeException((Object)value, Enum.class.toString(), targetType.toString(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IncompatibleTypeException((Object)value, Enum.class.toString(), targetType.toString(), e);
        }
    }

    public static Object convertNumber(String value, Class<? extends Number> numberType) {
        if (value == null) {
            return null;
        }
        Validate.isTrue((Number.class.isAssignableFrom(numberType) || ValueConverter.isPrimitiveNumber(numberType) ? 1 : 0) != 0);
        if (NumberUtils.isNumber((String)value)) {
            if (Integer.class.equals(numberType) || Integer.TYPE.equals(numberType) || Number.class.equals(numberType)) {
                return Integer.parseInt(value);
            }
            if (Byte.class.equals(numberType) || Byte.TYPE.equals(numberType)) {
                return Byte.parseByte(value);
            }
            if (Short.class.equals(numberType) || Short.TYPE.equals(numberType)) {
                return Short.parseShort(value);
            }
            if (Long.class.equals(numberType) || Long.TYPE.equals(numberType)) {
                return Long.parseLong(value);
            }
            if (Float.class.equals(numberType) || Float.TYPE.equals(numberType)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (Double.class.equals(numberType) || Double.TYPE.equals(numberType)) {
                return Double.parseDouble(value);
            }
            if (BigInteger.class.equals(numberType)) {
                return BigInteger.valueOf(Long.parseLong(value));
            }
            if (BigDecimal.class.equals(numberType)) {
                return BigDecimal.valueOf(Long.parseLong(value));
            }
            throw new IncompatibleTypeException(value, value.getClass().toString(), numberType.toString());
        }
        throw new IncompatibleTypeException(value, value.getClass().toString(), numberType.toString());
    }

    public static final boolean isPrimitiveNumber(Class<?> targetType) {
        return PRIMITIVE_NUMBER_TYPES.contains(targetType);
    }

    public static final class IncompatibleTypeException
    extends RuntimeException {
        private static final long serialVersionUID = -9234872336546L;
        private static final String pattern = "error: unable to convert value '%s': '%s' to '%s'";

        public IncompatibleTypeException(String message, Exception e) {
            super(message, e);
        }

        public IncompatibleTypeException(Object value, String className, String targetName) {
            super(String.format(pattern, value, className, targetName));
        }

        public IncompatibleTypeException(Object value, String className, String targetName, Exception nestedException) {
            super(String.format(pattern, value, className, targetName), nestedException);
        }
    }
}

