/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyDelayedMethodInvoke;
import de.lessvoid.xml.tools.MethodResolver;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class NiftyMethodInvoker
implements NiftyDelayedMethodInvoke {
    private static Logger log = Logger.getLogger(NiftyMethodInvoker.class.getName());
    private Object[] target;
    private String methodWithName;
    private Nifty nifty;

    public NiftyMethodInvoker(Nifty nifty) {
        this.nifty = nifty;
        this.methodWithName = null;
        this.target = null;
    }

    public NiftyMethodInvoker(Nifty nifty, String methodParam, Object ... targetParam) {
        this.nifty = nifty;
        this.methodWithName = methodParam;
        if (targetParam == null || targetParam.length == 0) {
            this.target = null;
        } else {
            this.target = new Object[targetParam.length];
            System.arraycopy(targetParam, 0, this.target, 0, targetParam.length);
            log.fine("target objects for [" + this.methodWithName + "]");
            for (Object o : this.target) {
                log.fine(o.toString());
            }
        }
    }

    public boolean invoke(Object ... invokeParametersParam) {
        if (this.target == null || this.target.length == 0 || this.methodWithName == null) {
            return false;
        }
        this.nifty.delayedMethodInvoke(this, invokeParametersParam);
        return true;
    }

    @Override
    public void performInvoke(Object ... invokeParametersParam) {
        for (Object object : this.target) {
            if (object != null) {
                Method method = MethodResolver.findMethod(object.getClass(), this.methodWithName);
                if (method != null) {
                    Object methodResult = null;
                    Object[] invokeParameters = MethodResolver.extractParameters(this.methodWithName);
                    if (invokeParameters.length > 0) {
                        if (this.getMethodParameterCount(method) == invokeParameters.length) {
                            log.fine("invoking method '" + this.methodWithName + "' with (" + this.debugParaString(invokeParameters) + ")");
                            methodResult = this.callMethod(object, method, invokeParameters);
                        } else {
                            log.fine("invoking method '" + this.methodWithName + "' (note: given invokeParameters have been ignored)");
                            methodResult = this.callMethod(object, method, new Object[0]);
                        }
                    } else if (invokeParametersParam.length > 0) {
                        if (this.getMethodParameterCount(method) == invokeParametersParam.length) {
                            log.fine("invoking method '" + this.methodWithName + "' with the actual parameters (" + this.debugParaString(invokeParametersParam) + ")");
                            methodResult = this.callMethod(object, method, invokeParametersParam);
                        } else {
                            log.fine("invoking method '" + this.methodWithName + "' without parameters (invokeParametersParam mismatch)");
                            methodResult = this.callMethod(object, method, null);
                        }
                    } else {
                        log.fine("invoking method '" + this.methodWithName + "' without parameters");
                        methodResult = this.callMethod(object, method, null);
                    }
                    if (methodResult == null || !methodResult.getClass().equals(Boolean.class) || !((Boolean)methodResult).booleanValue()) continue;
                    log.fine("method invoke for '" + this.methodWithName + "' returns true. by definition this means we're not calling any other targets for this method.");
                    return;
                }
                log.fine("method [" + this.methodWithName + "] not found at object class [" + object.getClass() + "]");
                continue;
            }
            log.warning("target object is null");
        }
    }

    private Object callMethod(Object targetObject, Method method, Object[] invokeParameters) {
        try {
            log.fine("method: " + method + "on targetObject: " + targetObject + ", parameters: " + invokeParameters);
            if (method != null) {
                log.fine(method.getName());
            }
            if (invokeParameters != null) {
                for (Object o : invokeParameters) {
                    log.fine("parameter: " + o);
                }
            }
            return method.invoke(targetObject, invokeParameters);
        }
        catch (RuntimeException e) {
            log.warning("RuntimeException: " + e.toString());
            this.logException(e);
            return null;
        }
        catch (Exception e) {
            log.warning("Exception: " + e.toString());
            this.logException(e);
            return null;
        }
    }

    private void logException(Throwable e) {
        StackTraceElement[] elements = e.getStackTrace();
        if (elements == null) {
            log.warning("stacktrace is null");
        } else {
            for (StackTraceElement ee : elements) {
                log.warning(ee.getClassName() + " " + ee.getMethodName() + " (" + ee.getFileName() + ":" + ee.getLineNumber() + ")");
            }
        }
        if (e.getCause() != null) {
            log.warning("Root Cause: " + e.getCause().toString());
            this.logException(e.getCause());
        }
    }

    private int getMethodParameterCount(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length;
    }

    private String debugParaString(Object[] invokeParameters) {
        StringBuffer paraStringBuffer = new StringBuffer();
        paraStringBuffer.append(invokeParameters[0]);
        for (int i = 1; i < invokeParameters.length; ++i) {
            paraStringBuffer.append(", ");
            paraStringBuffer.append(invokeParameters[i]);
        }
        return paraStringBuffer.toString();
    }
}

