/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.builder;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.HoverEffectBuilder;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectsAttributes;
import de.lessvoid.nifty.loaderv2.types.StyleType;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collection;

public class StyleBuilder {
    private Attributes styleAttributes = new Attributes();
    private ControlAttributes attributes = new ControlAttributes();
    private Collection<EffectBuilder> onStartScreen = new ArrayList<EffectBuilder>();
    private Collection<EffectBuilder> onEndScreen = new ArrayList<EffectBuilder>();
    private Collection<HoverEffectBuilder> onHover = new ArrayList<HoverEffectBuilder>();
    private Collection<HoverEffectBuilder> onStartHover = new ArrayList<HoverEffectBuilder>();
    private Collection<HoverEffectBuilder> onEndHover = new ArrayList<HoverEffectBuilder>();
    private Collection<EffectBuilder> onClick = new ArrayList<EffectBuilder>();
    private Collection<EffectBuilder> onFocus = new ArrayList<EffectBuilder>();
    private Collection<EffectBuilder> onLostFocus = new ArrayList<EffectBuilder>();
    private Collection<EffectBuilder> onGetFocus = new ArrayList<EffectBuilder>();
    private Collection<EffectBuilder> onActive = new ArrayList<EffectBuilder>();
    private Collection<EffectBuilder> onCustom = new ArrayList<EffectBuilder>();
    private Collection<EffectBuilder> onShow = new ArrayList<EffectBuilder>();
    private Collection<EffectBuilder> onHide = new ArrayList<EffectBuilder>();

    public void id(String id) {
        this.styleAttributes.set("id", id);
    }

    public void base(String baseStyle) {
        this.styleAttributes.set("base", baseStyle);
    }

    public void name(String name) {
        this.attributes.setName(name);
    }

    public void backgroundColor(String backgroundColor) {
        this.attributes.setBackgroundColor(backgroundColor);
    }

    public void backgroundColor(Color backgroundColor) {
        this.attributes.setBackgroundColor(backgroundColor.getColorString());
    }

    public void color(String color) {
        this.attributes.setColor(color);
    }

    public void color(Color color) {
        this.attributes.setColor(color.getColorString());
    }

    public void selectionColor(String color) {
        this.attributes.setSelectionColor(color);
    }

    public void selectionColor(Color color) {
        this.attributes.setSelectionColor(color.getColorString());
    }

    public void text(String text) {
        this.attributes.setText(text);
    }

    public void backgroundImage(String backgroundImage) {
        this.attributes.setBackgroundImage(backgroundImage);
    }

    public void imageMode(String imageMode) {
        this.attributes.setImageMode(imageMode);
    }

    public void inset(String inset) {
        this.attributes.setInset(inset);
    }

    public void inputMapping(String inputMapping) {
        this.attributes.setInputMapping(inputMapping);
    }

    public void style(String style) {
        this.attributes.setStyle(style);
    }

    public void childLayout(ChildLayoutType childLayout) {
        this.attributes.setChildLayout(childLayout.getLayout());
    }

    public void childLayoutVertical() {
        this.childLayout(ChildLayoutType.Vertical);
    }

    public void childLayoutHorizontal() {
        this.childLayout(ChildLayoutType.Horizontal);
    }

    public void childLayoutCenter() {
        this.childLayout(ChildLayoutType.Center);
    }

    public void childLayoutAbsolute() {
        this.childLayout(ChildLayoutType.Absolute);
    }

    public void childLayoutOverlay() {
        this.childLayout(ChildLayoutType.Overlay);
    }

    public void height(String height) {
        this.attributes.setHeight(height);
    }

    public void width(String width) {
        this.attributes.setWidth(width);
    }

    public void x(String x) {
        this.attributes.setX(x);
    }

    public void y(String y) {
        this.attributes.setY(y);
    }

    public void childClip(boolean childClip) {
        this.attributes.setChildClip(String.valueOf(childClip));
    }

    public void renderOrder(int renderOrder) {
        this.attributes.setRenderOrder(renderOrder);
    }

    public void visible(boolean visible) {
        this.attributes.setVisible(String.valueOf(visible));
    }

    public void focusable(boolean focusable) {
        this.attributes.setFocusable(String.valueOf(focusable));
    }

    public void textHAlign(Align align) {
        this.attributes.set("textHAlign", align.getLayout());
    }

    public void textHAlignLeft() {
        this.textHAlign(Align.Left);
    }

    public void textHAlignRight() {
        this.textHAlign(Align.Right);
    }

    public void textHAlignCenter() {
        this.textHAlign(Align.Center);
    }

    public void textVAlign(VAlign valign) {
        this.attributes.set("textVAlign", valign.getLayout());
    }

    public void textVAlignTop() {
        this.textVAlign(VAlign.Top);
    }

    public void textVAlignBottom() {
        this.textVAlign(VAlign.Bottom);
    }

    public void textVAlignCenter() {
        this.textVAlign(VAlign.Center);
    }

    public void align(Align align) {
        this.attributes.setAlign(align.getLayout());
    }

    public void alignLeft() {
        this.align(Align.Left);
    }

    public void alignRight() {
        this.align(Align.Right);
    }

    public void alignCenter() {
        this.align(Align.Center);
    }

    public void valign(VAlign valign) {
        this.attributes.setVAlign(valign.getLayout());
    }

    public void valignTop() {
        this.valign(VAlign.Top);
    }

    public void valignBottom() {
        this.valign(VAlign.Bottom);
    }

    public void valignCenter() {
        this.valign(VAlign.Center);
    }

    public void visibleToMouse(boolean visibleToMouse) {
        this.attributes.setVisibleToMouse(String.valueOf(visibleToMouse));
    }

    public void visibleToMouse() {
        this.visibleToMouse(true);
    }

    public void invisibleToMouse() {
        this.visibleToMouse(false);
    }

    public void font(String font) {
        this.attributes.setFont(font);
    }

    public void filename(String filename) {
        this.attributes.setFilename(filename);
    }

    public void padding(String padding) {
        this.attributes.setPadding(padding);
    }

    public void paddingLeft(String padding) {
        this.attributes.setPaddingLeft(padding);
    }

    public void paddingRight(String padding) {
        this.attributes.setPaddingRight(padding);
    }

    public void paddingTop(String padding) {
        this.attributes.setPaddingTop(padding);
    }

    public void paddingBottom(String padding) {
        this.attributes.setPaddingBottom(padding);
    }

    public void margin(String margin) {
        this.attributes.setMargin(margin);
    }

    public void marginLeft(String margin) {
        this.attributes.setMarginLeft(margin);
    }

    public void marginRight(String margin) {
        this.attributes.setMarginRight(margin);
    }

    public void marginTop(String margin) {
        this.attributes.setMarginTop(margin);
    }

    public void marginBottom(String margin) {
        this.attributes.setMarginBottom(margin);
    }

    public void set(String key, String value) {
        this.attributes.set(key, value);
    }

    public void onStartScreenEffect(EffectBuilder onStartScreenEffect) {
        this.onStartScreen.add(onStartScreenEffect);
    }

    public void onEndScreenEffect(EffectBuilder onEndScreenEffect) {
        this.onEndScreen.add(onEndScreenEffect);
    }

    public void onHoverEffect(HoverEffectBuilder onHoverEffect) {
        this.onHover.add(onHoverEffect);
    }

    public void onStartHoverEffect(HoverEffectBuilder onStartHoverEffect) {
        this.onStartHover.add(onStartHoverEffect);
    }

    public void onEndHoverEffect(HoverEffectBuilder onEndHoverEffect) {
        this.onEndHover.add(onEndHoverEffect);
    }

    public void onClickEffect(EffectBuilder onClickEffect) {
        this.onClick.add(onClickEffect);
    }

    public void onFocusEffect(EffectBuilder onFocusEffect) {
        this.onFocus.add(onFocusEffect);
    }

    public void onLostFocusEffect(EffectBuilder onLostFocusEffect) {
        this.onLostFocus.add(onLostFocusEffect);
    }

    public void onGetFocusEffect(EffectBuilder onGetFocusEffect) {
        this.onGetFocus.add(onGetFocusEffect);
    }

    public void onActiveEffect(EffectBuilder onActiveEffect) {
        this.onActive.add(onActiveEffect);
    }

    public void onShowEffect(EffectBuilder onShowEffect) {
        this.onShow.add(onShowEffect);
    }

    public void onHideEffect(EffectBuilder onHideEffect) {
        this.onHide.add(onHideEffect);
    }

    public void onCustomEffect(EffectBuilder onCustomEffect) {
        this.onCustom.add(onCustomEffect);
    }

    public void interactOnClick(String method) {
        this.attributes.setInteractOnClick(method);
    }

    public void interactOnRelease(String onRelease) {
        this.attributes.setInteractOnRelease(onRelease);
    }

    public void interactOnMouseOver(String onMouseOver) {
        this.attributes.setInteractOnMouseOver(onMouseOver);
    }

    public void interactOnClickRepeat(String onClickRepeat) {
        this.attributes.setInteractOnClickRepeat(onClickRepeat);
    }

    public void interactOnClickMouseMove(String onClickMouseMove) {
        this.attributes.setInteractOnClickMouseMove(onClickMouseMove);
    }

    public void interactOnClickAlternateKey(String onClickAlternateKey) {
        this.attributes.setInteractOnClickAlternateKey(onClickAlternateKey);
    }

    public String percentage(int percentage) {
        return Integer.toString(percentage) + "%";
    }

    public String pixels(int px) {
        return Integer.toString(px) + "px";
    }

    private void connectAttributes() {
        this.attributes.setEffects(this.createEffects());
        for (EffectBuilder effectBuilder : this.onStartScreen) {
            this.attributes.addEffectsOnStartScreen(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onEndScreen) {
            this.attributes.addEffectsOnEndScreen(effectBuilder.getAttributes());
        }
        for (HoverEffectBuilder hoverEffectBuilder : this.onHover) {
            this.attributes.addEffectsOnHover(hoverEffectBuilder.getAttributes());
        }
        for (HoverEffectBuilder hoverEffectBuilder : this.onStartHover) {
            this.attributes.addEffectsOnStartHover(hoverEffectBuilder.getAttributes());
        }
        for (HoverEffectBuilder hoverEffectBuilder : this.onEndHover) {
            this.attributes.addEffectsOnEndHover(hoverEffectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onClick) {
            this.attributes.addEffectsOnClick(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onFocus) {
            this.attributes.addEffectsOnFocus(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onLostFocus) {
            this.attributes.addEffectsOnLostFocus(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onGetFocus) {
            this.attributes.addEffectsOnGetFocus(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onActive) {
            this.attributes.addEffectsOnActive(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onCustom) {
            this.attributes.addEffectsOnCustom(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onShow) {
            this.attributes.addEffectsOnShow(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onHide) {
            this.attributes.addEffectsOnHide(effectBuilder.getAttributes());
        }
    }

    private ControlEffectsAttributes createEffects() {
        return new ControlEffectsAttributes();
    }

    public void build(Nifty nifty) {
        this.connectAttributes();
        StyleType style = this.attributes.createStyleType(this.styleAttributes);
        nifty.registerStyle(style);
    }

    public static enum VAlign {
        Top("top"),
        Bottom("bottom"),
        Center("center");

        private String valign;

        private VAlign(String valign) {
            this.valign = valign;
        }

        public String getLayout() {
            return this.valign;
        }
    }

    public static enum Align {
        Left("left"),
        Right("right"),
        Center("center");

        private String align;

        private Align(String align) {
            this.align = align;
        }

        public String getLayout() {
            return this.align;
        }
    }

    public static enum ChildLayoutType {
        Vertical("vertical"),
        Horizontal("horizontal"),
        Center("center"),
        Absolute("absolute"),
        AbsoluteInside("absolute-inside"),
        Overlay("overlay");

        private String layout;

        private ChildLayoutType(String layout) {
            this.layout = layout;
        }

        public String getLayout() {
            return this.layout;
        }
    }
}

