/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class MenuItemControl
extends AbstractController {
    private Screen screen;
    private Element element;
    private FocusHandler focusHandler;

    @Override
    public void bind(Nifty nifty, Screen screenParam, Element newElement, Properties properties, Attributes controlDefinitionAttributes) {
        this.element = newElement;
        this.screen = screenParam;
    }

    @Override
    public void onStartScreen() {
        this.focusHandler = this.screen.getFocusHandler();
    }

    @Override
    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyInputEvent.NextInputElement) {
            if (this.focusHandler != null) {
                Element nextElement = this.focusHandler.getNext(this.element);
                nextElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.PrevInputElement) {
            if (this.focusHandler != null) {
                Element prevElement = this.focusHandler.getPrev(this.element);
                prevElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.MoveCursorDown) {
            Element nextElement;
            if (this.focusHandler != null && (nextElement = this.focusHandler.getNext(this.element)).getParent().equals(this.element.getParent())) {
                nextElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.MoveCursorUp) {
            Element prevElement;
            if (this.focusHandler != null && (prevElement = this.focusHandler.getPrev(this.element)).getParent().equals(this.element.getParent())) {
                prevElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.Activate) {
            this.element.onClick();
            return true;
        }
        return false;
    }

    @Override
    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
    }
}

