/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects;

import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.Properties;

public class Falloff {
    public static final String HOVER_FALLOFF_TYPE = "hoverFalloffType";
    public static final String HOVER_FALLOFF_CONSTRAINT = "hoverFalloffConstraint";
    public static final String HOVER_WIDTH = "hoverWidth";
    public static final String HOVER_HEIGHT = "hoverHeight";
    private HoverFalloffType falloffType = HoverFalloffType.none;
    private HoverFalloffConstraint falloffConstraint = HoverFalloffConstraint.none;
    private SizeValue hoverWidth;
    private SizeValue hoverHeight;
    private float falloffValue;

    public Falloff(Properties parameter) {
        String hoverHeightString;
        String hoverWidthString;
        String falloffConstraintString;
        String falloffTypeString = parameter.getProperty(HOVER_FALLOFF_TYPE);
        if (falloffTypeString != null) {
            this.falloffType = HoverFalloffType.valueOf(falloffTypeString);
        }
        if ((falloffConstraintString = parameter.getProperty(HOVER_FALLOFF_CONSTRAINT)) != null) {
            this.falloffConstraint = HoverFalloffConstraint.valueOf(falloffConstraintString);
        }
        if ((hoverWidthString = parameter.getProperty(HOVER_WIDTH)) != null) {
            this.hoverWidth = new SizeValue(hoverWidthString);
        }
        if ((hoverHeightString = parameter.getProperty(HOVER_HEIGHT)) != null) {
            this.hoverHeight = new SizeValue(hoverHeightString);
        }
    }

    public Falloff() {
    }

    public void applyProperties(Properties parameter) {
    }

    public final boolean isInside(Element widget, int x, int y) {
        int centerX = widget.getX() + widget.getWidth() / 2;
        int centerY = widget.getY() + widget.getHeight() / 2;
        int horizontalHover = this.getHorizontalHover(widget);
        int verticalHover = this.getVerticalHover(widget);
        return x > centerX - horizontalHover / 2 && x <= centerX + horizontalHover / 2 && y > centerY - verticalHover / 2 && y <= centerY + verticalHover / 2;
    }

    private int getVerticalHover(Element widget) {
        if (this.hoverHeight == null) {
            return widget.getHeight();
        }
        return this.hoverHeight.getValueAsInt(widget.getHeight());
    }

    private int getHorizontalHover(Element widget) {
        if (this.hoverWidth == null) {
            return widget.getWidth();
        }
        return this.hoverWidth.getValueAsInt(widget.getWidth());
    }

    public void updateFalloffValue(Element element, int mouseX, int mouseY) {
        float d;
        if (this.falloffConstraint == HoverFalloffConstraint.none) {
            this.falloffValue = 1.0f;
            return;
        }
        int centerX = element.getX() + element.getWidth() / 2;
        int centerY = element.getY() + element.getHeight() / 2;
        float dx = mouseX - centerX;
        float dy = mouseY - centerY;
        float falloff = 0.0f;
        if (this.falloffConstraint == HoverFalloffConstraint.vertical) {
            dx = 0.0f;
            falloff = this.getVerticalHover(element) / 2;
        }
        if (this.falloffConstraint == HoverFalloffConstraint.horizontal) {
            dy = 0.0f;
            falloff = this.getHorizontalHover(element) / 2;
        }
        if (this.falloffConstraint == HoverFalloffConstraint.both) {
            double dA = 0.0;
            dA = dy == 0.0f && dx == 0.0f ? 0.0 : Math.abs(Math.atan(dy / dx));
            float elA = this.getHorizontalHover(element) / 2;
            float elB = this.getVerticalHover(element) / 2;
            double dB = 0.0;
            dB = Math.abs(Math.atan(elB / elA));
            if (Math.abs(Math.toDegrees(dA)) >= 0.0 && Math.abs(Math.toDegrees(dA)) <= Math.abs(Math.toDegrees(dB))) {
                falloff = (float)((double)elA / Math.cos(dA));
            }
            if (Math.abs(Math.toDegrees(dA)) > Math.abs(Math.toDegrees(dB)) && Math.abs(Math.toDegrees(dA)) <= 90.0) {
                falloff = (float)((double)elB / Math.sin(dA));
            }
        }
        if ((d = (float)Math.hypot(dx, dy)) > falloff) {
            this.falloffValue = 0.0f;
        }
        this.falloffValue = Math.abs(1.0f - d / falloff);
    }

    public float getFalloffValue() {
        return this.falloffValue;
    }

    public HoverFalloffConstraint getFalloffConstraint() {
        return this.falloffConstraint;
    }

    public static enum HoverFalloffConstraint {
        none,
        vertical,
        horizontal,
        both;

    }

    public static enum HoverFalloffType {
        none,
        linear;

    }
}

