/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyIdCreator;
import de.lessvoid.nifty.builder.ControlBuilder;
import de.lessvoid.nifty.builder.LayerBuilder;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.SizeValue;

public class Hint
implements EffectImpl {
    private Nifty nifty;
    private String hintLayerId;
    private String hintPanelId;
    private int hintDelay;
    private String offsetX;
    private String offsetY;

    @Override
    public void activate(Nifty niftyParam, Element element, EffectProperties parameter) {
        this.nifty = niftyParam;
        final String hintControl = parameter.getProperty("hintControl", "nifty-default-hint");
        final String hintStyle = parameter.getProperty("hintStyle", null);
        final String hintText = parameter.getProperty("hintText", "hint: add a 'hintText' attribute to the hint effect :)");
        this.hintDelay = Integer.valueOf(parameter.getProperty("hintDelay", "0"));
        this.offsetX = parameter.getProperty("offsetX", "0");
        this.offsetY = parameter.getProperty("offsetY", "0");
        this.hintLayerId = NiftyIdCreator.generate();
        this.hintPanelId = this.hintLayerId + "-hint-panel";
        new LayerBuilder(this.hintLayerId){
            {
                super(x0);
                this.childLayoutAbsoluteInside();
                this.visible(false);
                this.control(new ControlBuilder(Hint.this.hintPanelId, hintControl){
                    {
                        this.parameter("hintText", hintText);
                        if (hintStyle != null) {
                            this.style(hintStyle);
                        }
                    }
                });
            }
        }.build(niftyParam, niftyParam.getCurrentScreen(), niftyParam.getCurrentScreen().getRootElement());
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        Element hintPanel;
        Element hintLayer;
        if ((double)normalizedTime > 0.0 && (hintLayer = this.nifty.getCurrentScreen().findElementByName(this.hintLayerId)) != null && !hintLayer.isVisible() && this.nifty.getNiftyMouse().getNoMouseMovementTime() > (long)this.hintDelay && (hintPanel = hintLayer.findElementByName(this.hintPanelId)) != null) {
            hintPanel.setConstraintX(new SizeValue(this.getPosX(element, hintPanel, r.getWidth()) + "px"));
            hintPanel.setConstraintY(new SizeValue(this.getPosY(element, hintPanel, r.getHeight()) + "px"));
            hintLayer.layoutElements();
            hintLayer.show();
        }
    }

    @Override
    public void deactivate() {
        final Element hintLayer = this.nifty.getCurrentScreen().findElementByName(this.hintLayerId);
        if (hintLayer == null) {
            return;
        }
        if (hintLayer.isVisible()) {
            hintLayer.startEffect(EffectEventId.onCustom, new EndNotify(){

                @Override
                public void perform() {
                    hintLayer.markForRemoval();
                }
            });
        } else {
            hintLayer.markForRemoval();
        }
    }

    private int getPosX(Element element, Element hintPanel, int screenWidth) {
        int pos = 0;
        pos = "center".equals(this.offsetX) ? element.getX() + element.getWidth() / 2 - hintPanel.getWidth() / 2 : ("left".equals(this.offsetX) ? element.getX() : ("right".equals(this.offsetX) ? element.getX() + element.getWidth() - hintPanel.getWidth() : Integer.valueOf(this.offsetX)));
        if (pos < 0) {
            pos = 0;
        }
        if (pos + hintPanel.getWidth() > screenWidth) {
            pos = screenWidth - hintPanel.getWidth();
        }
        return pos;
    }

    private int getPosY(Element element, Element hintPanel, int screenHeight) {
        int pos = 0;
        pos = "center".equals(this.offsetY) ? element.getY() + element.getHeight() / 2 - hintPanel.getHeight() / 2 : ("top".equals(this.offsetY) ? element.getY() : ("bottom".equals(this.offsetY) ? element.getY() + element.getHeight() - hintPanel.getHeight() : Integer.valueOf(this.offsetY)));
        if (pos < 0) {
            pos = 0;
        }
        if (pos + hintPanel.getHeight() > screenHeight) {
            pos = screenHeight - hintPanel.getHeight();
        }
        return pos;
    }
}

