/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.nifty.tools.pulsate.Pulsator;

public class Pulsate
implements EffectImpl {
    private Color currentColor = new Color("#000f");
    private Color startColor;
    private Color endColor;
    private SizeValue width;
    private Pulsator pulsator;
    private boolean changeColorOnly = false;
    private boolean activated = false;

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.startColor = new Color(parameter.getProperty("startColor", "#00000000"));
        this.endColor = new Color(parameter.getProperty("endColor", "#ffffffff"));
        this.width = new SizeValue(parameter.getProperty("width"));
        this.changeColorOnly = new Boolean(parameter.getProperty("changeColorOnly", "false"));
        this.pulsator = new Pulsator(parameter, nifty.getTimeProvider());
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        if (!this.activated && normalizedTime > 0.0f) {
            this.activated = true;
            this.pulsator.reset();
        }
        if (this.activated) {
            if (!this.changeColorOnly) {
                r.saveState(null);
            }
            float value = this.pulsator.update();
            this.currentColor.linear(this.startColor, this.endColor, value);
            r.setColor(this.currentColor);
            if (!this.changeColorOnly) {
                int size = (int)this.width.getValue(element.getParent().getWidth());
                if (size == -1) {
                    r.renderQuad(element.getX(), element.getY(), element.getWidth(), element.getHeight());
                } else {
                    r.renderQuad(element.getX() + element.getWidth() / 2 - size / 2, element.getY(), size, element.getHeight());
                }
            }
            if (!this.changeColorOnly) {
                r.restoreState();
            }
        }
    }

    @Override
    public void deactivate() {
        this.activated = true;
    }
}

