/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.NiftyMouseEvent;
import de.lessvoid.nifty.elements.events.NiftyMouseMovedEvent;
import de.lessvoid.nifty.elements.events.NiftyMouseWheelEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;

public class ElementInteractionMoveHandler {
    private Nifty nifty;
    private Element element;
    private int lastMouseX;
    private int lastMouseY;
    private boolean lastButton0Down;
    private boolean lastButton1Down;
    private boolean lastButton2Down;

    public ElementInteractionMoveHandler(Nifty nifty, Element element) {
        this.nifty = nifty;
        this.element = element;
        this.lastMouseX = 0;
        this.lastMouseY = 0;
        this.lastButton0Down = false;
        this.lastButton1Down = false;
        this.lastButton2Down = false;
    }

    public void process(boolean canHandleInteraction, boolean mouseInside, boolean hasMouseAccess, NiftyMouseInputEvent mouseEvent) {
        if (canHandleInteraction && mouseInside) {
            boolean moved = this.handleMoveEvent(mouseEvent);
            boolean wheel = this.handleWheelEvent(mouseEvent);
            if (moved || wheel) {
                this.handleGeneralEvent(mouseEvent);
            } else {
                boolean generateEvent = false;
                if (mouseEvent.isButton0Down() != this.lastButton0Down) {
                    this.lastButton0Down = mouseEvent.isButton0Down();
                    generateEvent = true;
                }
                if (mouseEvent.isButton1Down() != this.lastButton1Down) {
                    this.lastButton1Down = mouseEvent.isButton1Down();
                    generateEvent = true;
                }
                if (mouseEvent.isButton2Down() != this.lastButton2Down) {
                    this.lastButton2Down = mouseEvent.isButton2Down();
                    generateEvent = true;
                }
                if (generateEvent) {
                    this.handleGeneralEvent(mouseEvent);
                }
            }
        }
    }

    private boolean handleMoveEvent(NiftyMouseInputEvent mouseEvent) {
        if (mouseEvent.getMouseX() != this.lastMouseX || mouseEvent.getMouseY() != this.lastMouseY) {
            this.lastMouseX = mouseEvent.getMouseX();
            this.lastMouseY = mouseEvent.getMouseY();
            this.nifty.publishEvent(this.element.getId(), new NiftyMouseMovedEvent(this.element, mouseEvent));
            return true;
        }
        return false;
    }

    private boolean handleWheelEvent(NiftyMouseInputEvent mouseEvent) {
        if (mouseEvent.getMouseWheel() != 0) {
            this.nifty.publishEvent(this.element.getId(), new NiftyMouseWheelEvent(this.element, mouseEvent));
            return true;
        }
        return false;
    }

    private void handleGeneralEvent(NiftyMouseInputEvent mouseEvent) {
        this.nifty.publishEvent(this.element.getId(), new NiftyMouseEvent(this.element, mouseEvent));
    }
}

