/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ObjectPool<T> {
    private static Logger log = Logger.getLogger(ObjectPool.class.getName());
    private List<T> pool;
    private List<Integer> free;
    private Map<T, Integer> indexLookUp;
    private Factory<T> factory;

    public ObjectPool(int size, Factory<T> initialFactory) {
        this.factory = initialFactory;
        this.pool = new ArrayList<T>(size);
        this.free = new ArrayList<Integer>(size);
        this.indexLookUp = new HashMap<T, Integer>(size);
        for (int i = 0; i < size; ++i) {
            T item = initialFactory.createNew();
            this.pool.add(item);
            this.free.add(i);
            this.indexLookUp.put(item, i);
        }
    }

    public T allocate() {
        if (this.free.isEmpty()) {
            int size = this.pool.size();
            log.warning("running ouf of pool objects! used capacity [" + size + "] new capacity [" + size * 2 + "]");
            for (int i = 0; i < size; ++i) {
                T item = this.factory.createNew();
                this.pool.add(item);
                this.free.add(size + i);
                this.indexLookUp.put(item, size + i);
            }
        }
        Integer index = this.free.remove(this.free.size() - 1);
        return this.pool.get(index);
    }

    public void free(T item) {
        int index = this.indexLookUp.get(item);
        this.free.add(index);
    }

    public int getFreeCount() {
        return this.pool.size() - this.free.size();
    }

    public static interface Factory<T> {
        public T createNew();
    }
}

