/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.lwxs;

import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import de.lessvoid.xml.lwxs.XmlType;
import de.lessvoid.xml.lwxs.elements.Element;
import de.lessvoid.xml.lwxs.elements.SubstitutionGroup;
import de.lessvoid.xml.lwxs.elements.Type;
import de.lessvoid.xml.lwxs.elements.XmlProcessorType;
import de.lessvoid.xml.lwxs.processor.IncludeProcessor;
import de.lessvoid.xml.lwxs.processor.TypeProcessor;
import de.lessvoid.xml.xpp3.Attributes;
import de.lessvoid.xml.xpp3.XmlParser;
import de.lessvoid.xml.xpp3.XmlProcessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Schema
implements XmlProcessor {
    private static Logger log = Logger.getLogger(Schema.class.getName());
    private Map<String, Type> types = new HashMap<String, Type>();
    private String packageString;
    private String root;
    private String type;
    private NiftyResourceLoader resourceLoader;

    public Schema(NiftyResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void process(XmlParser xmlParser, Attributes attributes) throws Exception {
        this.packageString = attributes.get("package");
        if (this.packageString == null) {
            throw new Exception("[package] attribute is a required attribute");
        }
        this.root = attributes.get("root");
        if (this.root == null) {
            throw new Exception("[root] attribute is a required attribute");
        }
        this.type = attributes.get("type");
        if (this.type == null) {
            throw new Exception("[type] attribute is a required attribute");
        }
        xmlParser.nextTag();
        xmlParser.zeroOrMore(new de.lessvoid.xml.xpp3.SubstitutionGroup().add("include", new IncludeProcessor(this.resourceLoader, this.types)).add("type", new TypeProcessor(this)));
    }

    public void addType(String name, Type typeParam) {
        this.types.put(name, typeParam);
    }

    public Type getType(String name) throws Exception {
        Type t = this.types.get(name);
        if (t == null) {
            log.warning("Type [" + name + "] not found. Creating new one on the fly");
            t = new Type(name, null);
            this.addType(name, t);
        }
        return t;
    }

    public boolean isTypeAvailable(String name) {
        return this.types.containsKey(name);
    }

    public XmlType loadXml(XmlParser parser) throws Exception {
        Type t = this.getType(this.type);
        XmlProcessorType xmlType = t.createXmlProcessor(this);
        parser.nextTag();
        parser.required(this.root, xmlType);
        return xmlType.getXmlType();
    }

    public XmlProcessorType getInstance(String className, Collection<Element> elements, Collection<SubstitutionGroup> substitutionGroups) throws Exception {
        XmlProcessorType processor = new XmlProcessorType(this.packageString + "." + className);
        for (Element child : elements) {
            child.addToProcessor(this, processor);
        }
        for (SubstitutionGroup subst : substitutionGroups) {
            subst.addToProcessor(this, processor);
        }
        return processor;
    }

    public Map<String, Type> getTypes() {
        return this.types;
    }
}

