/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.tools;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Logger;

public class MethodResolver {
    private static Logger log = Logger.getLogger(MethodResolver.class.getName());

    private MethodResolver() {
    }

    public static Method findMethod(Class<?> c, String methodName) {
        Method[] ms;
        if (c == null) {
            return null;
        }
        String methodNameOnly = MethodResolver.extractMethodName(methodName);
        if (methodNameOnly == null) {
            log.warning("Could not extract method from [" + methodName + "]");
            return null;
        }
        for (Method m : ms = c.getMethods()) {
            if (!methodNameOnly.equalsIgnoreCase(m.getName())) continue;
            return m;
        }
        return MethodResolver.findMethod(c.getSuperclass(), methodName);
    }

    public static Method findMethodWithArgs(Class<?> c, String methodName, Class<?> ... parameters) {
        Method[] ms;
        if (c == null) {
            return null;
        }
        String methodNameOnly = MethodResolver.extractMethodName(methodName);
        if (methodNameOnly == null) {
            log.warning("Could not extract method from [" + methodName + "]");
            return null;
        }
        for (Method m : ms = c.getMethods()) {
            if (!methodNameOnly.equalsIgnoreCase(m.getName()) || !Arrays.equals(m.getParameterTypes(), parameters)) continue;
            return m;
        }
        return null;
    }

    public static String[] extractParameters(String methodName) {
        String parameterString = MethodResolver.extractArgs(methodName);
        if (parameterString == null || parameterString.length() == 0) {
            return new String[0];
        }
        String[] result = parameterString.split(",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public static String extractArgs(String methodName) {
        int startIdx = methodName.indexOf("(");
        int endIdx = methodName.lastIndexOf(")");
        if (startIdx == -1 || endIdx == -1) {
            return "";
        }
        return methodName.substring(startIdx + 1, endIdx);
    }

    private static String extractMethodName(String methodName) {
        if (!methodName.contains("(")) {
            return null;
        }
        return methodName.substring(0, methodName.indexOf(40));
    }
}

