/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl;

import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import org.cogchar.demo.render.opengl.UnfinishedDemoApp;

public class DemoOtoIntersectsMovableBlock
extends UnfinishedDemoApp {
    Geometry geom1;
    Spatial golem;
    private AnalogListener analogListener = new AnalogListener(){

        public void onAnalog(String name, float value, float tpf) {
            if (name.equals("MoveRight")) {
                DemoOtoIntersectsMovableBlock.this.geom1.move(2.0f * tpf, 0.0f, 0.0f);
            }
            if (name.equals("MoveLeft")) {
                DemoOtoIntersectsMovableBlock.this.geom1.move(-2.0f * tpf, 0.0f, 0.0f);
            }
            if (name.equals("MoveUp")) {
                DemoOtoIntersectsMovableBlock.this.geom1.move(0.0f, 2.0f * tpf, 0.0f);
            }
            if (name.equals("MoveDown")) {
                DemoOtoIntersectsMovableBlock.this.geom1.move(0.0f, -2.0f * tpf, 0.0f);
            }
        }
    };

    public static void main(String[] args) {
        DemoOtoIntersectsMovableBlock app = new DemoOtoIntersectsMovableBlock();
        app.start();
    }

    public void simpleInitApp() {
        super.simpleInitApp();
        Box mesh1 = new Box(0.5f, 0.5f, 0.5f);
        this.geom1 = new Geometry("Box", (Mesh)mesh1);
        this.geom1.move(2.0f, 2.0f, -0.5f);
        Material m1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        m1.setColor("Color", ColorRGBA.Blue);
        this.geom1.setMaterial(m1);
        this.rootNode.attachChild((Spatial)this.geom1);
        this.golem = this.assetManager.loadModel("Models/Oto/Oto.mesh.xml");
        this.golem.scale(0.5f);
        this.golem.setLocalTranslation(-1.0f, -1.5f, -0.6f);
        this.setupLight();
        this.inputManager.addMapping("MoveRight", new Trigger[]{new KeyTrigger(38)});
        this.inputManager.addMapping("MoveLeft", new Trigger[]{new KeyTrigger(36)});
        this.inputManager.addMapping("MoveUp", new Trigger[]{new KeyTrigger(23)});
        this.inputManager.addMapping("MoveDown", new Trigger[]{new KeyTrigger(37)});
        this.inputManager.addListener((InputListener)this.analogListener, new String[]{"MoveRight", "MoveLeft", "MoveUp", "MoveDown"});
    }

    public void simpleUpdate(float tpf) {
        CollisionResults results = new CollisionResults();
        BoundingVolume bv = this.geom1.getWorldBound();
        this.golem.collideWith((Collidable)bv, results);
        if (results.size() > 0) {
            this.geom1.getMaterial().setColor("Color", ColorRGBA.Red);
        } else {
            this.geom1.getMaterial().setColor("Color", ColorRGBA.Blue);
        }
    }
}

