/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.LoopMode;
import com.jme3.app.state.AppState;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.CharacterControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.util.CollisionShapeFactory;
import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.effect.shapes.EmitterShape;
import com.jme3.effect.shapes.EmitterSphereShape;
import com.jme3.input.ChaseCamera;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.ImageBasedHeightMap;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import java.util.ArrayList;
import org.cogchar.demo.render.opengl.UnfinishedDemoApp;
import org.cogchar.render.goody.physical.LaunchableCollidingRigidBodyControl;

public class DemoOtoWalksTerrainAndBombsWall
extends UnfinishedDemoApp
implements ActionListener,
PhysicsCollisionListener,
AnimEventListener {
    private BulletAppState bulletAppState;
    CharacterControl character;
    Node model;
    Vector3f walkDirection = new Vector3f();
    TerrainQuad terrain;
    RigidBodyControl terrainPhysicsNode;
    Material matRock;
    Material matBullet;
    AnimChannel animationChannel;
    AnimChannel shootingChannel;
    AnimControl animationControl;
    float airTime = 0.0f;
    boolean left = false;
    boolean right = false;
    boolean up = false;
    boolean down = false;
    ChaseCamera chaseCam;
    Sphere bullet;
    SphereCollisionShape bulletCollisionShape;
    ParticleEmitter effect;
    Box brick;
    float bLength = 0.8f;
    float bWidth = 0.4f;
    float bHeight = 0.4f;
    FilterPostProcessor fpp;

    public static void main(String[] args) {
        DemoOtoWalksTerrainAndBombsWall app = new DemoOtoWalksTerrainAndBombsWall();
        app.start();
    }

    public void simpleInitApp() {
        super.simpleInitApp();
        this.bulletAppState = new BulletAppState();
        this.bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        this.stateManager.attach((AppState)this.bulletAppState);
        this.setupKeys();
        this.prepareBullet();
        this.prepareEffect();
        this.setupLight();
        this.createSky();
        this.createTerrain();
        this.createWall();
        this.createCharacter();
        this.setupChaseCamera();
        this.setupAnimationController();
        this.setupFilter();
    }

    private void setupFilter() {
        FilterPostProcessor fpp = new FilterPostProcessor(this.assetManager);
        BloomFilter bloom = new BloomFilter(BloomFilter.GlowMode.Objects);
        fpp.addFilter((Filter)bloom);
        this.viewPort.addProcessor((SceneProcessor)fpp);
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    private void setupKeys() {
        this.inputManager.addMapping("wireframe", new Trigger[]{new KeyTrigger(20)});
        this.inputManager.addListener((InputListener)this, new String[]{"wireframe"});
        this.inputManager.addMapping("CharLeft", new Trigger[]{new KeyTrigger(30)});
        this.inputManager.addMapping("CharRight", new Trigger[]{new KeyTrigger(32)});
        this.inputManager.addMapping("CharUp", new Trigger[]{new KeyTrigger(17)});
        this.inputManager.addMapping("CharDown", new Trigger[]{new KeyTrigger(31)});
        this.inputManager.addMapping("CharSpace", new Trigger[]{new KeyTrigger(28)});
        this.inputManager.addMapping("CharShoot", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addListener((InputListener)this, new String[]{"CharLeft"});
        this.inputManager.addListener((InputListener)this, new String[]{"CharRight"});
        this.inputManager.addListener((InputListener)this, new String[]{"CharUp"});
        this.inputManager.addListener((InputListener)this, new String[]{"CharDown"});
        this.inputManager.addListener((InputListener)this, new String[]{"CharSpace"});
        this.inputManager.addListener((InputListener)this, new String[]{"CharShoot"});
    }

    private void createWall() {
        float xOff = -144.0f;
        float zOff = -40.0f;
        float startpt = this.bLength / 4.0f - xOff;
        float height = 6.1f;
        this.brick = new Box(Vector3f.ZERO, this.bLength, this.bHeight, this.bWidth);
        this.brick.scaleTextureCoordinates(new Vector2f(1.0f, 0.5f));
        for (int j = 0; j < 15; ++j) {
            for (int i = 0; i < 4; ++i) {
                Vector3f vt = new Vector3f((float)i * this.bLength * 2.0f + startpt, this.bHeight + height, zOff);
                this.addBrick(vt);
            }
            startpt = -startpt;
            height += 1.01f * this.bHeight;
        }
    }

    private void addBrick(Vector3f ori) {
        Geometry reBoxg = new Geometry("brick", (Mesh)this.brick);
        reBoxg.setMaterial(this.matRock);
        reBoxg.setLocalTranslation(ori);
        reBoxg.addControl((Control)new RigidBodyControl(1.5f));
        reBoxg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.rootNode.attachChild((Spatial)reBoxg);
        this.getPhysicsSpace().add((Object)reBoxg);
    }

    private void prepareBullet() {
        this.bullet = new Sphere(32, 32, 0.4f, true, false);
        this.bullet.setTextureMode(Sphere.TextureMode.Projected);
        this.bulletCollisionShape = new SphereCollisionShape(0.4f);
        this.matBullet = new Material(this.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        this.matBullet.setColor("Color", ColorRGBA.Green);
        this.matBullet.setColor("m_GlowColor", ColorRGBA.Green);
        this.getPhysicsSpace().addCollisionListener((PhysicsCollisionListener)this);
    }

    private void prepareEffect() {
        int COUNT_FACTOR = 1;
        float COUNT_FACTOR_F = 1.0f;
        this.effect = new ParticleEmitter("Flame", ParticleMesh.Type.Triangle, 32 * COUNT_FACTOR);
        this.effect.setSelectRandomImage(true);
        this.effect.setStartColor(new ColorRGBA(1.0f, 0.4f, 0.05f, 1.0f / COUNT_FACTOR_F));
        this.effect.setEndColor(new ColorRGBA(0.4f, 0.22f, 0.12f, 0.0f));
        this.effect.setStartSize(1.3f);
        this.effect.setEndSize(2.0f);
        this.effect.setShape((EmitterShape)new EmitterSphereShape(Vector3f.ZERO, 1.0f));
        this.effect.setParticlesPerSec(0.0f);
        this.effect.setGravity(0.0f, -5.0f, 0.0f);
        this.effect.setLowLife(0.4f);
        this.effect.setHighLife(0.5f);
        this.effect.setInitialVelocity(new Vector3f(0.0f, 7.0f, 0.0f));
        this.effect.setVelocityVariation(1.0f);
        this.effect.setImagesX(2);
        this.effect.setImagesY(2);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Explosion/flame.png"));
        this.effect.setMaterial(mat);
        this.rootNode.attachChild((Spatial)this.effect);
    }

    private void createSky() {
        this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)"Textures/Sky/Bright/BrightSky.dds", (boolean)false));
    }

    private void createTerrain() {
        this.matRock = new Material(this.assetManager, "Common/MatDefs/Terrain/TerrainLighting.j3md");
        this.matRock.setBoolean("useTriPlanarMapping", false);
        this.matRock.setBoolean("WardIso", true);
        this.matRock.setTexture("AlphaMap", this.assetManager.loadTexture("Textures/Terrain/splat/alphamap.png"));
        Texture heightMapImage = this.assetManager.loadTexture("Textures/Terrain/splat/mountains512.png");
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap", grass);
        this.matRock.setFloat("DiffuseMap_0_scale", 64.0f);
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap_1", dirt);
        this.matRock.setFloat("DiffuseMap_1_scale", 16.0f);
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/splat/road.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap_2", rock);
        this.matRock.setFloat("DiffuseMap_2_scale", 128.0f);
        Texture normalMap0 = this.assetManager.loadTexture("Textures/Terrain/splat/grass_normal.jpg");
        normalMap0.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap1 = this.assetManager.loadTexture("Textures/Terrain/splat/dirt_normal.png");
        normalMap1.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap2 = this.assetManager.loadTexture("Textures/Terrain/splat/road_normal.png");
        normalMap2.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("NormalMap", normalMap0);
        this.matRock.setTexture("NormalMap_1", normalMap2);
        this.matRock.setTexture("NormalMap_2", normalMap2);
        ImageBasedHeightMap heightmap = null;
        try {
            heightmap = new ImageBasedHeightMap(heightMapImage.getImage(), 0.25f);
            heightmap.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.terrain = new TerrainQuad("terrain", 65, 513, heightmap.getHeightMap());
        ArrayList<Camera> cameras = new ArrayList<Camera>();
        cameras.add(this.getCamera());
        TerrainLodControl control = new TerrainLodControl((Terrain)this.terrain, cameras);
        this.terrain.addControl((Control)control);
        this.terrain.setMaterial(this.matRock);
        this.terrain.setLocalScale(new Vector3f(2.0f, 2.0f, 2.0f));
        this.terrainPhysicsNode = new RigidBodyControl(CollisionShapeFactory.createMeshShape((Spatial)this.terrain), 0.0f);
        this.terrain.addControl((Control)this.terrainPhysicsNode);
        this.rootNode.attachChild((Spatial)this.terrain);
        this.getPhysicsSpace().add((Object)this.terrainPhysicsNode);
    }

    private void createCharacter() {
        CapsuleCollisionShape capsule = new CapsuleCollisionShape(3.0f, 4.0f);
        this.character = new CharacterControl((CollisionShape)capsule, 0.01f);
        this.model = (Node)this.assetManager.loadModel("Models/Oto/Oto.mesh.xml");
        this.model.addControl((Control)this.character);
        this.character.setPhysicsLocation(new Vector3f(-140.0f, 15.0f, -10.0f));
        this.rootNode.attachChild((Spatial)this.model);
        this.getPhysicsSpace().add((Object)this.character);
    }

    private void setupChaseCamera() {
        this.flyCam.setEnabled(false);
        this.chaseCam = new ChaseCamera(this.cam, (Spatial)this.model, this.inputManager);
    }

    private void setupAnimationController() {
        this.animationControl = (AnimControl)this.model.getControl(AnimControl.class);
        this.animationControl.addListener((AnimEventListener)this);
        this.animationChannel = this.animationControl.createChannel();
        this.shootingChannel = this.animationControl.createChannel();
        this.shootingChannel.addBone(this.animationControl.getSkeleton().getBone("uparm.right"));
        this.shootingChannel.addBone(this.animationControl.getSkeleton().getBone("arm.right"));
        this.shootingChannel.addBone(this.animationControl.getSkeleton().getBone("hand.right"));
    }

    public void simpleUpdate(float tpf) {
        Vector3f camDir = this.cam.getDirection().clone().multLocal(0.1f);
        Vector3f camLeft = this.cam.getLeft().clone().multLocal(0.1f);
        camDir.y = 0.0f;
        camLeft.y = 0.0f;
        this.walkDirection.set(0.0f, 0.0f, 0.0f);
        if (this.left) {
            this.walkDirection.addLocal(camLeft);
        }
        if (this.right) {
            this.walkDirection.addLocal(camLeft.negate());
        }
        if (this.up) {
            this.walkDirection.addLocal(camDir);
        }
        if (this.down) {
            this.walkDirection.addLocal(camDir.negate());
        }
        this.airTime = !this.character.onGround() ? (this.airTime += tpf) : 0.0f;
        if (this.walkDirection.length() == 0.0f) {
            if (!"stand".equals(this.animationChannel.getAnimationName())) {
                this.animationChannel.setAnim("stand", 1.0f);
            }
        } else {
            this.character.setViewDirection(this.walkDirection);
            if (this.airTime > 0.3f) {
                if (!"stand".equals(this.animationChannel.getAnimationName())) {
                    this.animationChannel.setAnim("stand");
                }
            } else if (!"Walk".equals(this.animationChannel.getAnimationName())) {
                this.animationChannel.setAnim("Walk", 0.7f);
            }
        }
        this.character.setWalkDirection(this.walkDirection);
    }

    public void onAction(String binding, boolean value, float tpf) {
        if (binding.equals("CharLeft")) {
            this.left = value;
        } else if (binding.equals("CharRight")) {
            this.right = value;
        } else if (binding.equals("CharUp")) {
            this.up = value;
        } else if (binding.equals("CharDown")) {
            this.down = value;
        } else if (binding.equals("CharSpace")) {
            this.character.jump();
        } else if (binding.equals("CharShoot") && !value) {
            this.bulletControl();
        }
    }

    private void bulletControl() {
        this.shootingChannel.setAnim("Dodge", 0.1f);
        this.shootingChannel.setLoopMode(LoopMode.DontLoop);
        Geometry bulletg = new Geometry("bullet", (Mesh)this.bullet);
        bulletg.setMaterial(this.matBullet);
        bulletg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        bulletg.setLocalTranslation(this.character.getPhysicsLocation().add(this.cam.getDirection().mult(2.0f)));
        LaunchableCollidingRigidBodyControl bulletControl = new LaunchableCollidingRigidBodyControl((CollisionShape)this.bulletCollisionShape, 1.0f);
        bulletControl.setCcdMotionThreshold(0.1f);
        bulletControl.setLinearVelocity(this.cam.getDirection().mult(80.0f));
        bulletg.addControl((Control)bulletControl);
        this.rootNode.attachChild((Spatial)bulletg);
        this.getPhysicsSpace().add((Object)bulletControl);
    }

    public void collision(PhysicsCollisionEvent event) {
        if (event.getObjectA() instanceof LaunchableCollidingRigidBodyControl) {
            Spatial node = event.getNodeA();
            this.effect.killAllParticles();
            this.effect.setLocalTranslation(node.getLocalTranslation());
            this.effect.emitAllParticles();
        } else if (event.getObjectB() instanceof LaunchableCollidingRigidBodyControl) {
            Spatial node = event.getNodeB();
            this.effect.killAllParticles();
            this.effect.setLocalTranslation(node.getLocalTranslation());
            this.effect.emitAllParticles();
        }
    }

    public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
        if (channel == this.shootingChannel) {
            channel.setAnim("stand");
        }
    }

    public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
    }
}

