/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.SkyFactory;
import com.jme3.water.SimpleWaterProcessor;

public class DemoSimpleWater
extends SimpleApplication
implements ActionListener {
    Material mat;
    Spatial waterPlane;
    Geometry lightSphere;
    SimpleWaterProcessor waterProcessor;
    Node sceneNode;
    boolean useWater = true;
    private Vector3f lightPos = new Vector3f(33.0f, 12.0f, -29.0f);

    public static void main(String[] args) {
        DemoSimpleWater app = new DemoSimpleWater();
        app.start();
    }

    public void simpleInitApp() {
        this.initInput();
        this.initScene();
        this.waterProcessor = new SimpleWaterProcessor(this.assetManager);
        this.waterProcessor.setReflectionScene((Spatial)this.sceneNode);
        this.waterProcessor.setDebug(true);
        this.viewPort.addProcessor((SceneProcessor)this.waterProcessor);
        this.waterProcessor.setLightPosition(this.lightPos);
        this.waterPlane = (Spatial)this.assetManager.loadAsset("Models/WaterTest/WaterTest.mesh.xml");
        this.waterPlane.setMaterial(this.waterProcessor.getMaterial());
        this.waterPlane.setLocalScale(40.0f);
        this.waterPlane.setLocalTranslation(-5.0f, 0.0f, 5.0f);
        this.rootNode.attachChild(this.waterPlane);
    }

    private void initScene() {
        this.cam.setLocation(new Vector3f(0.0f, 10.0f, 10.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        this.sceneNode = new Node("Scene");
        this.mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat.setTexture("ColorMap", this.assetManager.loadTexture("Interface/Logo/Monkey.jpg"));
        Box b = new Box(1.0f, 1.0f, 1.0f);
        Geometry geom = new Geometry("Box", (Mesh)b);
        geom.setMaterial(this.mat);
        this.sceneNode.attachChild((Spatial)geom);
        this.sceneNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)"Textures/Sky/Bright/BrightSky.dds", (boolean)false));
        this.rootNode.attachChild((Spatial)this.sceneNode);
        Sphere lite = new Sphere(8, 8, 3.0f);
        this.lightSphere = new Geometry("lightsphere", (Mesh)lite);
        this.lightSphere.setMaterial(this.mat);
        this.lightSphere.setLocalTranslation(this.lightPos);
        this.rootNode.attachChild((Spatial)this.lightSphere);
    }

    protected void initInput() {
        this.flyCam.setMoveSpeed(3.0f);
        this.inputManager.addMapping("use_water", new Trigger[]{new KeyTrigger(24)});
        this.inputManager.addListener((InputListener)this, new String[]{"use_water"});
        this.inputManager.addMapping("lightup", new Trigger[]{new KeyTrigger(20)});
        this.inputManager.addListener((InputListener)this, new String[]{"lightup"});
        this.inputManager.addMapping("lightdown", new Trigger[]{new KeyTrigger(34)});
        this.inputManager.addListener((InputListener)this, new String[]{"lightdown"});
        this.inputManager.addMapping("lightleft", new Trigger[]{new KeyTrigger(35)});
        this.inputManager.addListener((InputListener)this, new String[]{"lightleft"});
        this.inputManager.addMapping("lightright", new Trigger[]{new KeyTrigger(37)});
        this.inputManager.addListener((InputListener)this, new String[]{"lightright"});
        this.inputManager.addMapping("lightforward", new Trigger[]{new KeyTrigger(22)});
        this.inputManager.addListener((InputListener)this, new String[]{"lightforward"});
        this.inputManager.addMapping("lightback", new Trigger[]{new KeyTrigger(36)});
        this.inputManager.addListener((InputListener)this, new String[]{"lightback"});
    }

    public void simpleUpdate(float tpf) {
        this.fpsText.setText("Light Position: " + this.lightPos.toString() + " Change Light position with [U], [H], [J], [K] and [T], [G] Turn off water with [O]");
        this.lightSphere.setLocalTranslation(this.lightPos);
        this.waterProcessor.setLightPosition(this.lightPos);
    }

    public void onAction(String name, boolean value, float tpf) {
        if (name.equals("use_water") && value) {
            if (!this.useWater) {
                this.useWater = true;
                this.waterPlane.setMaterial(this.waterProcessor.getMaterial());
            } else {
                this.useWater = false;
                this.waterPlane.setMaterial(this.mat);
            }
        } else if (name.equals("lightup") && value) {
            this.lightPos.y += 1.0f;
        } else if (name.equals("lightdown") && value) {
            this.lightPos.y -= 1.0f;
        } else if (name.equals("lightleft") && value) {
            this.lightPos.x -= 1.0f;
        } else if (name.equals("lightright") && value) {
            this.lightPos.x += 1.0f;
        } else if (name.equals("lightforward") && value) {
            this.lightPos.z -= 1.0f;
        } else if (name.equals("lightback") && value) {
            this.lightPos.z += 1.0f;
        }
    }
}

