/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl.brick;

import com.jme3.app.state.AppState;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.shadow.BasicShadowRenderer;
import com.jme3.system.AppSettings;
import org.cogchar.demo.render.opengl.brick.BrickApp;
import org.cogchar.render.app.bony.BonyGameFeatureAdapter;
import org.cogchar.render.sys.registry.RenderRegistryClient;

public class DemoYouBowlAtBrickWall
extends BrickApp {
    BasicShadowRenderer bsr;
    private RigidBodyControl brick_phy;
    private static final Box box;
    private RigidBodyControl ball_phy;
    private static final Sphere sphere;
    protected static float brickLength;
    protected static float brickWidth;
    protected static final float brickHeight = 0.12f;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("shoot") && !keyPressed) {
                DemoYouBowlAtBrickWall.this.makeCannonBall();
            }
        }
    };

    public static void main(String[] args) {
        DemoYouBowlAtBrickWall app = new DemoYouBowlAtBrickWall();
        app.start();
    }

    public void simpleInitApp() {
        super.simpleInitApp();
        this.stateManager.attach((AppState)this.myPhysAppState);
        this.cam.setLocation(new Vector3f(0.0f, 6.0f, 6.0f));
        this.cam.lookAt(Vector3f.ZERO, new Vector3f(0.0f, 1.0f, 0.0f));
        this.cam.setFrustumFar(15.0f);
        this.inputManager.addMapping("shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"shoot"});
        this.initWall();
        this.initFloorBowlWall();
        BonyGameFeatureAdapter.initCrossHairs((AppSettings)this.settings, (RenderRegistryClient)this.getRenderContext().getRenderRegistryClient());
    }

    public void initWall() {
        float startpt = brickLength / 4.0f;
        float height = 0.0f;
        for (int j = 0; j < 15; ++j) {
            for (int i = 0; i < 4; ++i) {
                Vector3f vt = new Vector3f((float)i * brickLength * 2.0f + startpt, 0.12f + height, 0.0f);
                this.makeBrick(vt);
            }
            startpt = -startpt;
            height += 0.24f;
        }
    }

    public void makeBrick(Vector3f loc) {
        Geometry brick_geo = new Geometry("brick", (Mesh)box);
        brick_geo.setMaterial(this.myBrickMat);
        brick_geo.setLocalTranslation(loc);
        brick_geo.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.makePhysicalObjControlAndAttachToRoot(brick_geo, 2.0f, null);
    }

    public void makeCannonBall() {
        Geometry ball_geo = new Geometry("cannon ball", (Mesh)sphere);
        ball_geo.setMaterial(this.myRockMat);
        this.rootNode.attachChild((Spatial)ball_geo);
        ball_geo.setLocalTranslation(this.cam.getLocation());
        ball_geo.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.ball_phy = new RigidBodyControl(1.0f);
        ball_geo.addControl((Control)this.ball_phy);
        this.myPhysAppState.getPhysicsSpace().add((Object)this.ball_phy);
        this.ball_phy.setLinearVelocity(this.cam.getDirection().mult(25.0f));
    }

    static {
        brickLength = 0.48f;
        brickWidth = 0.24f;
        sphere = new Sphere(32, 32, 0.4f, true, false);
        sphere.setTextureMode(Sphere.TextureMode.Projected);
        box = new Box(Vector3f.ZERO, brickLength, 0.12f, brickWidth);
        box.scaleTextureCoordinates(new Vector2f(1.0f, 0.5f));
    }
}

