/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl.jme3;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Torus;

public class DemoRandomRigidBodyShapes
extends SimpleApplication {
    private BulletAppState bulletAppState;
    private Material mat1;
    private Material mat2;
    private Material mat3;

    public static void main(String[] args) {
        DemoRandomRigidBodyShapes app = new DemoRandomRigidBodyShapes();
        app.start();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        this.bulletAppState.getPhysicsSpace().enableDebug(this.assetManager);
        this.createMaterial();
        Node node = new Node("node1");
        this.attachRandomGeometry(node, this.mat1);
        this.randomizeTransform((Spatial)node);
        Node node2 = new Node("node2");
        this.attachRandomGeometry(node2, this.mat2);
        this.randomizeTransform((Spatial)node2);
        node.attachChild((Spatial)node2);
        this.rootNode.attachChild((Spatial)node);
        RigidBodyControl control = new RigidBodyControl(0.0f);
        node.addControl((Control)control);
        this.getPhysicsSpace().add((Object)control);
        Geometry myGeom = new Geometry("cylinder", (Mesh)new Cylinder(16, 16, 0.5f, 1.0f));
        myGeom.setMaterial(this.mat3);
        this.randomizeTransform((Spatial)myGeom);
        this.rootNode.attachChild((Spatial)myGeom);
        RigidBodyControl control3 = new RigidBodyControl(0.0f);
        myGeom.addControl((Control)control3);
        this.getPhysicsSpace().add((Object)control3);
    }

    private void attachRandomGeometry(Node node, Material mat) {
        Box box = new Box(0.25f, 0.25f, 0.25f);
        Torus torus = new Torus(16, 16, 0.2f, 0.8f);
        Geometry[] boxes = new Geometry[]{new Geometry("box1", (Mesh)box), new Geometry("box2", (Mesh)box), new Geometry("box3", (Mesh)box), new Geometry("torus1", (Mesh)torus), new Geometry("torus2", (Mesh)torus), new Geometry("torus3", (Mesh)torus)};
        for (int i = 0; i < boxes.length; ++i) {
            Geometry geometry = boxes[i];
            geometry.setLocalTranslation((float)Math.random() * 10.0f - 10.0f, (float)Math.random() * 10.0f - 10.0f, (float)Math.random() * 10.0f - 10.0f);
            geometry.setLocalRotation(new Quaternion().fromAngles((float)Math.random() * (float)Math.PI, (float)Math.random() * (float)Math.PI, (float)Math.random() * (float)Math.PI));
            geometry.setLocalScale((float)Math.random() * 10.0f - 10.0f, (float)Math.random() * 10.0f - 10.0f, (float)Math.random() * 10.0f - 10.0f);
            geometry.setMaterial(mat);
            node.attachChild((Spatial)geometry);
        }
    }

    private void randomizeTransform(Spatial spat) {
        spat.setLocalTranslation((float)Math.random() * 10.0f, (float)Math.random() * 10.0f, (float)Math.random() * 10.0f);
        spat.setLocalTranslation((float)Math.random() * 10.0f, (float)Math.random() * 10.0f, (float)Math.random() * 10.0f);
        spat.setLocalScale((float)Math.random() * 2.0f, (float)Math.random() * 2.0f, (float)Math.random() * 2.0f);
    }

    private void createMaterial() {
        this.mat1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat1.setColor("Color", ColorRGBA.Green);
        this.mat2 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat2.setColor("Color", ColorRGBA.Red);
        this.mat3 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat3.setColor("Color", ColorRGBA.Yellow);
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }
}

