/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl;

import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.debug.Grid;
import com.jme3.scene.debug.WireBox;
import com.jme3.scene.debug.WireSphere;
import org.cogchar.demo.render.opengl.UnfinishedDemoApp;

public class DemoDrawnShapes
extends UnfinishedDemoApp {
    public static void main(String[] args) {
        DemoDrawnShapes app = new DemoDrawnShapes();
        app.start();
    }

    public Geometry putShape(Mesh shape, ColorRGBA color) {
        Geometry g = new Geometry("shape", shape);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        this.rootNode.attachChild((Spatial)g);
        return g;
    }

    public Geometry putArrow(Vector3f pos, Vector3f dir, ColorRGBA color) {
        Arrow arrow = new Arrow(dir);
        arrow.setLineWidth(4.0f);
        Geometry g = this.putShape((Mesh)arrow, color);
        g.setLocalTranslation(pos);
        return g;
    }

    public Geometry putBox(Vector3f pos, float size, ColorRGBA color) {
        Geometry g = this.putShape((Mesh)new WireBox(size, size, size), color);
        g.setLocalTranslation(pos);
        return g;
    }

    public Geometry putGrid(Vector3f pos, ColorRGBA color) {
        Geometry g = this.putShape((Mesh)new Grid(6, 6, 0.2f), color);
        g.center().move(pos);
        return g;
    }

    public Geometry putSphere(Vector3f pos, ColorRGBA color) {
        Geometry g = this.putShape((Mesh)new WireSphere(1.0f), color);
        g.setLocalTranslation(pos);
        return g;
    }

    public void simpleInitApp() {
        super.simpleInitApp();
        this.cam.setLocation(new Vector3f(2.0f, 1.5f, 2.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        this.putArrow(Vector3f.ZERO, Vector3f.UNIT_X, ColorRGBA.Red);
        this.putArrow(Vector3f.ZERO, Vector3f.UNIT_Y, ColorRGBA.Green);
        this.putArrow(Vector3f.ZERO, Vector3f.UNIT_Z, ColorRGBA.Blue);
        Geometry whiteHope = this.putArrow(Vector3f.ZERO, Vector3f.UNIT_XYZ, ColorRGBA.White);
        Quaternion tq = new Quaternion();
        float rot_X_bank = 0.0f;
        float rot_Y_heading = 0.0f;
        float rot_Z_attitude = 0.62831855f;
        tq.fromAngles(rot_X_bank, rot_Y_heading, rot_Z_attitude);
        whiteHope.rotate(tq);
        this.putBox(new Vector3f(2.0f, 0.0f, 0.0f), 0.5f, ColorRGBA.Yellow);
        this.putGrid(new Vector3f(3.5f, 0.0f, 0.0f), ColorRGBA.White);
        this.putSphere(new Vector3f(4.5f, 0.0f, 0.0f), ColorRGBA.Magenta);
    }
}

