/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl;

import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.joints.ConeJoint;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import org.cogchar.blob.emit.RenderConfigEmitter;
import org.cogchar.render.app.core.CogcharPresumedApp;
import org.cogchar.render.sys.context.CogcharRenderContext;
import org.cogchar.render.sys.context.ConfiguredPhysicalModularRenderContext;

public class DemoFloatableWireframeRagdoll
extends CogcharPresumedApp {
    private Node ragDoll = new Node();
    private Node shoulders;
    private Vector3f upforce = new Vector3f(0.0f, 200.0f, 0.0f);
    private boolean applyForce = false;

    public static void main(String[] args) {
        RenderConfigEmitter rce = new RenderConfigEmitter();
        DemoFloatableWireframeRagdoll app = new DemoFloatableWireframeRagdoll(rce);
        app.start();
    }

    public DemoFloatableWireframeRagdoll(RenderConfigEmitter rce) {
        super(rce);
    }

    protected CogcharRenderContext makeCogcharRenderContext() {
        return new DFWR_RenderContext();
    }

    class DFWR_RenderContext
    extends ConfiguredPhysicalModularRenderContext
    implements ActionListener {
        DFWR_RenderContext() {
        }

        public void completeInit() {
            super.completeInit();
            DemoFloatableWireframeRagdoll.this.inputManager.addMapping("Pull ragdoll up", new Trigger[]{new MouseButtonTrigger(0)});
            DemoFloatableWireframeRagdoll.this.inputManager.addListener((InputListener)this, new String[]{"Pull ragdoll up"});
            this.initBasicTestPhysics();
            this.createRagDoll();
        }

        private void createRagDoll() {
            DemoFloatableWireframeRagdoll.this.shoulders = this.createLimb(0.2f, 1.0f, new Vector3f(0.0f, 1.5f, 0.0f), true);
            Node uArmL = this.createLimb(0.2f, 0.5f, new Vector3f(-0.75f, 0.8f, 0.0f), false);
            Node uArmR = this.createLimb(0.2f, 0.5f, new Vector3f(0.75f, 0.8f, 0.0f), false);
            Node lArmL = this.createLimb(0.2f, 0.5f, new Vector3f(-0.75f, -0.2f, 0.0f), false);
            Node lArmR = this.createLimb(0.2f, 0.5f, new Vector3f(0.75f, -0.2f, 0.0f), false);
            Node body = this.createLimb(0.2f, 1.0f, new Vector3f(0.0f, 0.5f, 0.0f), false);
            Node hips = this.createLimb(0.2f, 0.5f, new Vector3f(0.0f, -0.5f, 0.0f), true);
            Node uLegL = this.createLimb(0.2f, 0.5f, new Vector3f(-0.25f, -1.2f, 0.0f), false);
            Node uLegR = this.createLimb(0.2f, 0.5f, new Vector3f(0.25f, -1.2f, 0.0f), false);
            Node lLegL = this.createLimb(0.2f, 0.5f, new Vector3f(-0.25f, -2.2f, 0.0f), false);
            Node lLegR = this.createLimb(0.2f, 0.5f, new Vector3f(0.25f, -2.2f, 0.0f), false);
            this.join(body, DemoFloatableWireframeRagdoll.this.shoulders, new Vector3f(0.0f, 1.4f, 0.0f));
            this.join(body, hips, new Vector3f(0.0f, -0.5f, 0.0f));
            this.join(uArmL, DemoFloatableWireframeRagdoll.this.shoulders, new Vector3f(-0.75f, 1.4f, 0.0f));
            this.join(uArmR, DemoFloatableWireframeRagdoll.this.shoulders, new Vector3f(0.75f, 1.4f, 0.0f));
            this.join(uArmL, lArmL, new Vector3f(-0.75f, 0.4f, 0.0f));
            this.join(uArmR, lArmR, new Vector3f(0.75f, 0.4f, 0.0f));
            this.join(uLegL, hips, new Vector3f(-0.25f, -0.5f, 0.0f));
            this.join(uLegR, hips, new Vector3f(0.25f, -0.5f, 0.0f));
            this.join(uLegL, lLegL, new Vector3f(-0.25f, -1.7f, 0.0f));
            this.join(uLegR, lLegR, new Vector3f(0.25f, -1.7f, 0.0f));
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)DemoFloatableWireframeRagdoll.this.shoulders);
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)body);
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)hips);
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)uArmL);
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)uArmR);
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)lArmL);
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)lArmR);
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)uLegL);
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)uLegR);
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)lLegL);
            DemoFloatableWireframeRagdoll.this.ragDoll.attachChild((Spatial)lLegR);
            DemoFloatableWireframeRagdoll.this.rootNode.attachChild((Spatial)DemoFloatableWireframeRagdoll.this.ragDoll);
            this.getPhysicsSpace().addAll((Spatial)DemoFloatableWireframeRagdoll.this.ragDoll);
        }

        private Node createLimb(float width, float height, Vector3f location, boolean rotate) {
            int axis = rotate ? 0 : 1;
            CapsuleCollisionShape shape = new CapsuleCollisionShape(width, height, axis);
            Node node = new Node("Limb");
            RigidBodyControl rigidBodyControl = new RigidBodyControl((CollisionShape)shape, 1.0f);
            node.setLocalTranslation(location);
            node.addControl((Control)rigidBodyControl);
            return node;
        }

        private PhysicsJoint join(Node A, Node B, Vector3f connectionPoint) {
            Vector3f pivotA = A.worldToLocal(connectionPoint, new Vector3f());
            Vector3f pivotB = B.worldToLocal(connectionPoint, new Vector3f());
            ConeJoint joint = new ConeJoint((PhysicsRigidBody)A.getControl(RigidBodyControl.class), (PhysicsRigidBody)B.getControl(RigidBodyControl.class), pivotA, pivotB);
            joint.setLimit(1.0f, 1.0f, 0.0f);
            return joint;
        }

        public void onAction(String string, boolean bln, float tpf) {
            if ("Pull ragdoll up".equals(string)) {
                if (bln) {
                    ((RigidBodyControl)DemoFloatableWireframeRagdoll.this.shoulders.getControl(RigidBodyControl.class)).activate();
                    DemoFloatableWireframeRagdoll.this.applyForce = true;
                } else {
                    DemoFloatableWireframeRagdoll.this.applyForce = false;
                }
            }
        }

        public void doUpdate(float tpf) {
            if (DemoFloatableWireframeRagdoll.this.applyForce) {
                ((RigidBodyControl)DemoFloatableWireframeRagdoll.this.shoulders.getControl(RigidBodyControl.class)).applyForce(DemoFloatableWireframeRagdoll.this.upforce, Vector3f.ZERO);
            }
        }
    }
}

