/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.LoopMode;
import com.jme3.asset.TextureKey;
import com.jme3.bullet.control.KinematicRagdollControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.texture.Texture;
import org.cogchar.blob.emit.RenderConfigEmitter;
import org.cogchar.render.app.core.PhysicalApp;
import org.cogchar.render.sys.context.CogcharRenderContext;
import org.cogchar.render.sys.context.ConfiguredPhysicalModularRenderContext;
import org.cogchar.render.sys.context.CoreFeatureAdapter;
import org.cogchar.render.sys.registry.RenderRegistryClient;

public class DemoSinbadVersusBlocks
extends PhysicalApp {
    Node model;
    KinematicRagdollControl ragdoll;
    boolean leftStrafe = false;
    boolean rightStrafe = false;
    boolean forward = false;
    boolean backward = false;
    boolean leftRotate = false;
    boolean rightRotate = false;
    AnimControl animControl;
    AnimChannel animChannel;

    public static void main(String[] args) {
        RenderConfigEmitter dce = new RenderConfigEmitter();
        DemoSinbadVersusBlocks app = new DemoSinbadVersusBlocks(dce);
        app.start();
    }

    public DemoSinbadVersusBlocks(RenderConfigEmitter rce) {
        super(rce);
    }

    protected CogcharRenderContext makeCogcharRenderContext() {
        DSVB_RenderContext rc = new DSVB_RenderContext();
        return rc;
    }

    class DSVB_RenderContext
    extends ConfiguredPhysicalModularRenderContext
    implements AnimEventListener,
    ActionListener {
        DSVB_RenderContext() {
        }

        public void completeInit() {
            super.completeInit();
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            this.setupKeys();
            this.initBasicTestPhysics();
            this.initWall(2.0f, 1.0f, 1.0f);
            CoreFeatureAdapter.setupLight((CogcharRenderContext)this);
            DemoSinbadVersusBlocks.this.cam.setLocation(new Vector3f(-8.0f, 0.0f, -4.0f));
            DemoSinbadVersusBlocks.this.cam.lookAt(new Vector3f(4.0f, 0.0f, -7.0f), Vector3f.UNIT_Y);
            DemoSinbadVersusBlocks.this.model = (Node)rrc.getSceneSpatialModelFacade(null).makeSinbadSpatialFromDefaultPath();
            DemoSinbadVersusBlocks.this.model.lookAt(new Vector3f(0.0f, 0.0f, -1.0f), Vector3f.UNIT_Y);
            DemoSinbadVersusBlocks.this.model.setLocalTranslation(4.0f, 0.0f, -7.0f);
            DemoSinbadVersusBlocks.this.ragdoll = new KinematicRagdollControl(0.5f);
            DemoSinbadVersusBlocks.this.model.addControl((Control)DemoSinbadVersusBlocks.this.ragdoll);
            this.getPhysicsSpace().add((Object)DemoSinbadVersusBlocks.this.ragdoll);
            DemoSinbadVersusBlocks.this.speed = 1.3f;
            DemoSinbadVersusBlocks.this.rootNode.attachChild((Spatial)DemoSinbadVersusBlocks.this.model);
            AnimControl control = (AnimControl)DemoSinbadVersusBlocks.this.model.getControl(AnimControl.class);
            DemoSinbadVersusBlocks.this.animChannel = control.createChannel();
            DemoSinbadVersusBlocks.this.animChannel.setAnim("IdleTop");
            control.addListener((AnimEventListener)this);
        }

        public void doUpdate(float tpf) {
            if (DemoSinbadVersusBlocks.this.forward) {
                DemoSinbadVersusBlocks.this.model.move(DemoSinbadVersusBlocks.this.model.getLocalRotation().multLocal(new Vector3f(0.0f, 0.0f, 1.0f)).multLocal(tpf));
            } else if (DemoSinbadVersusBlocks.this.backward) {
                DemoSinbadVersusBlocks.this.model.move(DemoSinbadVersusBlocks.this.model.getLocalRotation().multLocal(new Vector3f(0.0f, 0.0f, 1.0f)).multLocal(-tpf));
            } else if (DemoSinbadVersusBlocks.this.leftRotate) {
                DemoSinbadVersusBlocks.this.model.rotate(0.0f, tpf, 0.0f);
            } else if (DemoSinbadVersusBlocks.this.rightRotate) {
                DemoSinbadVersusBlocks.this.model.rotate(0.0f, -tpf, 0.0f);
            }
            DemoSinbadVersusBlocks.this.fpsText.setText(DemoSinbadVersusBlocks.this.cam.getLocation() + "/" + DemoSinbadVersusBlocks.this.cam.getRotation());
        }

        public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
        }

        public void onAction(String binding, boolean value, float tpf) {
            if (binding.equals("Rotate Left")) {
                DemoSinbadVersusBlocks.this.leftRotate = value;
            } else if (binding.equals("Rotate Right")) {
                DemoSinbadVersusBlocks.this.rightRotate = value;
            } else if (binding.equals("Walk Forward")) {
                DemoSinbadVersusBlocks.this.forward = value;
            } else if (binding.equals("Walk Backward")) {
                DemoSinbadVersusBlocks.this.backward = value;
            } else if (binding.equals("Slice") && value) {
                DemoSinbadVersusBlocks.this.animChannel.setAnim("SliceHorizontal");
                DemoSinbadVersusBlocks.this.animChannel.setSpeed(0.3f);
            }
        }

        public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
            if (channel.getAnimationName().equals("SliceHorizontal")) {
                channel.setLoopMode(LoopMode.DontLoop);
                channel.setAnim("IdleTop", 5.0f);
                channel.setLoopMode(LoopMode.Loop);
            }
        }

        private void setupKeys() {
            DemoSinbadVersusBlocks.this.inputManager.addMapping("Rotate Left", new Trigger[]{new KeyTrigger(35)});
            DemoSinbadVersusBlocks.this.inputManager.addMapping("Rotate Right", new Trigger[]{new KeyTrigger(37)});
            DemoSinbadVersusBlocks.this.inputManager.addMapping("Walk Forward", new Trigger[]{new KeyTrigger(22)});
            DemoSinbadVersusBlocks.this.inputManager.addMapping("Walk Backward", new Trigger[]{new KeyTrigger(36)});
            DemoSinbadVersusBlocks.this.inputManager.addMapping("Slice", new Trigger[]{new KeyTrigger(57), new KeyTrigger(28)});
            DemoSinbadVersusBlocks.this.inputManager.addListener((InputListener)this, new String[]{"Strafe Left", "Strafe Right"});
            DemoSinbadVersusBlocks.this.inputManager.addListener((InputListener)this, new String[]{"Rotate Left", "Rotate Right"});
            DemoSinbadVersusBlocks.this.inputManager.addListener((InputListener)this, new String[]{"Walk Forward", "Walk Backward"});
            DemoSinbadVersusBlocks.this.inputManager.addListener((InputListener)this, new String[]{"Slice"});
        }

        public void initWall(float bLength, float bWidth, float bHeight) {
            Box brick = new Box(Vector3f.ZERO, bLength, bHeight, bWidth);
            brick.scaleTextureCoordinates(new Vector2f(1.0f, 0.5f));
            Material mat2 = new Material(DemoSinbadVersusBlocks.this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            TextureKey key = new TextureKey("Textures/Terrain/BrickWall/BrickWall.jpg");
            key.setGenerateMips(true);
            Texture tex = DemoSinbadVersusBlocks.this.assetManager.loadTexture(key);
            mat2.setTexture("ColorMap", tex);
            float startpt = bLength / 4.0f;
            float height = -5.0f;
            for (int j = 0; j < 15; ++j) {
                for (int i = 0; i < 4; ++i) {
                    Vector3f ori = new Vector3f((float)i * bLength * 2.0f + startpt, bHeight + height, -10.0f);
                    Geometry reBoxg = new Geometry("brick", (Mesh)brick);
                    reBoxg.setMaterial(mat2);
                    reBoxg.setLocalTranslation(ori);
                    reBoxg.addControl((Control)new RigidBodyControl(1.5f));
                    reBoxg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                    ((RigidBodyControl)reBoxg.getControl(RigidBodyControl.class)).setFriction(0.6f);
                    DemoSinbadVersusBlocks.this.rootNode.attachChild((Spatial)reBoxg);
                    this.getPhysicsSpace().add((Object)reBoxg);
                }
                startpt = -startpt;
                height += 2.0f * bHeight;
            }
        }
    }
}

