/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl;

import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.font.BitmapText;
import com.jme3.font.Rectangle;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.PQTorus;
import com.jme3.scene.shape.Quad;
import com.jme3.scene.shape.Sphere;
import com.jme3.system.AppSettings;
import org.cogchar.demo.render.opengl.UnfinishedDemoApp;
import org.cogchar.render.app.bony.BonyGameFeatureAdapter;
import org.cogchar.render.model.bony.SpatialManipFuncs;
import org.cogchar.render.opengl.optic.RayCollisionMgr;
import org.cogchar.render.sys.context.CogcharRenderContext;
import org.cogchar.render.sys.context.ConfiguredPhysicalModularRenderContext;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.slf4j.Logger;

public class DemoYouPickStuff
extends UnfinishedDemoApp {
    private static String MARK_ACTION = "markSpot";
    private static String ARROW_NORMAL = "arrowNormal";

    public static void main(String[] args) {
        DemoYouPickStuff app = new DemoYouPickStuff();
        app.start();
    }

    @Override
    protected CogcharRenderContext makeCogcharRenderContext() {
        DYPS_RenderContext rc = new DYPS_RenderContext();
        return rc;
    }

    public void simpleInitApp() {
        super.simpleInitApp();
        this.flyCam.setMoveSpeed(20.0f);
    }

    public class DYPS_RenderContext
    extends ConfiguredPhysicalModularRenderContext {
        Node myShootablesRootNode;
        Geometry myMark;
        Geometry myArrowMark;
        private ActionListener actionListener = new ActionListener(){

            public void onAction(String name, boolean keyPressed, float tpf) {
                if (name.equals(MARK_ACTION) && !keyPressed) {
                    CollisionResults coRes = RayCollisionMgr.getCameraCollisions((Camera)DemoYouPickStuff.this.cam, (Node)DYPS_RenderContext.this.myShootablesRootNode);
                    RayCollisionMgr.printCollisionDebug((Logger)DYPS_RenderContext.this.getLogger(), (CollisionResults)coRes);
                    RenderRegistryClient rrc = DYPS_RenderContext.this.getRenderRegistryClient();
                    if (coRes.size() > 0) {
                        CollisionResult closest = coRes.getClosestCollision();
                        DYPS_RenderContext.this.myMark.setLocalTranslation(closest.getContactPoint());
                        rrc.getSceneDeepFacade(null).attachTopSpatial((Spatial)DYPS_RenderContext.this.myMark);
                    } else {
                        rrc.getSceneDeepFacade(null).detachTopSpatial((Spatial)DYPS_RenderContext.this.myMark);
                    }
                }
            }
        };

        public void completeInit() {
            BonyGameFeatureAdapter.initCrossHairs((AppSettings)DemoYouPickStuff.this.settings, (RenderRegistryClient)this.getRenderRegistryClient());
            this.initKeys();
            this.initMark();
            this.initArrowMark();
            DemoYouPickStuff.this.setupLight();
            this.myShootablesRootNode = new Node("Shootables");
            DemoYouPickStuff.this.rootNode.attachChild((Spatial)this.myShootablesRootNode);
            this.myShootablesRootNode.attachChild((Spatial)this.makeCube("a Dragon", -2.0f, 0.0f, 1.0f, 3.0f));
            this.myShootablesRootNode.attachChild((Spatial)this.makeCube("a tin can", 1.0f, -2.0f, 0.0f, 1.5f));
            this.myShootablesRootNode.attachChild((Spatial)this.makeCube("the Sheriff", 0.0f, 1.0f, -2.0f, 1.0f));
            this.myShootablesRootNode.attachChild((Spatial)this.makeCube("the Deputy", 1.0f, 0.0f, -4.0f, 0.5f));
            this.myShootablesRootNode.attachChild((Spatial)this.makeFloor());
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            Spatial otoSpatial = rrc.getSceneSpatialModelFacade(null).makeOtoSpatialFromDefaultPath();
            SpatialManipFuncs.dumpNodeTree((Node)((Node)otoSpatial), (String)"XX ");
            otoSpatial.scale(0.5f);
            otoSpatial.setLocalTranslation(-1.0f, -1.5f, -0.6f);
            this.myShootablesRootNode.attachChild(otoSpatial);
            Geometry rr = this.makeBlueQuadGeom();
            this.myShootablesRootNode.attachChild((Spatial)rr);
            BitmapText btSpatial = this.makeTextSpatial();
            this.myShootablesRootNode.attachChild((Spatial)btSpatial);
        }

        private Geometry makeBlueQuadGeom() {
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            Quad q = new Quad(6.0f, 3.0f);
            Geometry g = rrc.getSceneGeometryFacade(null).makeColoredUnshadedGeom("blueRect", (Mesh)q, ColorRGBA.Blue, null);
            g.setLocalTranslation(0.0f, -3.0f, -1.0E-4f);
            return g;
        }

        private BitmapText makeTextSpatial() {
            String txtB = "ABCDEFGHIKLMNOPQRSTUVWXYZ1234567890`~!@#$%^&*()-=_+[]\\;',./{}|:<>?";
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            BitmapText txtSpatial = rrc.getSceneTextFacade(null).getScaledBitmapText(txtB, 1.0f);
            txtSpatial.setBox(new Rectangle(0.0f, 0.0f, 6.0f, 3.0f));
            txtSpatial.setQueueBucket(RenderQueue.Bucket.Transparent);
            txtSpatial.setSize(0.5f);
            txtSpatial.setText(txtB);
            return txtSpatial;
        }

        private void initKeys() {
            DemoYouPickStuff.this.inputManager.addMapping(MARK_ACTION, new Trigger[]{new KeyTrigger(57), new MouseButtonTrigger(0)});
            DemoYouPickStuff.this.inputManager.addListener((InputListener)this.actionListener, new String[]{MARK_ACTION});
        }

        protected Geometry makeCube(String geomName, float x, float y, float z, float sideLen) {
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            Box cubeMesh = rrc.getMeshShapeFacade(null).makeBoxMesh(new Vector3f(x, y, z), sideLen, sideLen, sideLen);
            Geometry cubeGeom = rrc.getSceneGeometryFacade(null).makeRandomlyColoredUnshadedGeom(geomName, (Mesh)cubeMesh, null);
            return cubeGeom;
        }

        protected Geometry makeFloor() {
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            Box floorMesh = rrc.getMeshShapeFacade(null).makeBoxMesh(new Vector3f(0.0f, -4.0f, -5.0f), 15.0f, 0.2f, 15.0f);
            Geometry floorGeom = rrc.getSceneGeometryFacade(null).makeColoredUnshadedGeom("theFloor", (Mesh)floorMesh, ColorRGBA.Gray, null);
            return floorGeom;
        }

        protected Geometry makePQT(String geomName, float p, float q, float radius, float width, int steps, int radialSamples) {
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            PQTorus pqtMesh = rrc.getMeshShapeFacade(null).makePQTorusMesh(p, q, radius, width, steps, radialSamples);
            Geometry pqtGeom = rrc.getSceneGeometryFacade(null).makeRandomlyColoredUnshadedGeom(geomName, (Mesh)pqtMesh, null);
            return pqtGeom;
        }

        protected void initMark() {
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            Sphere markMesh = rrc.getMeshShapeFacade(null).makeSphereMesh(30, 30, 0.2f);
            this.myMark = rrc.getSceneGeometryFacade(null).makeColoredUnshadedGeom("theMark", (Mesh)markMesh, ColorRGBA.Red, null);
        }

        protected void initArrowMark() {
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            Arrow arrow = rrc.getMeshFancyFacade(null).makeArrowMesh(Vector3f.UNIT_Z.mult(2.0f), Float.valueOf(3.0f));
            this.myArrowMark = rrc.getSceneGeometryFacade(null).makeColoredUnshadedGeom(ARROW_NORMAL, (Mesh)arrow, ColorRGBA.Red, null);
        }

        public void doUpdate(float tpf) {
            CollisionResults coRes = RayCollisionMgr.getCameraCollisions((Camera)DemoYouPickStuff.this.cam, (Node)this.myShootablesRootNode);
            if (coRes.size() > 0) {
                CollisionResult closest = coRes.getClosestCollision();
                this.myArrowMark.setLocalTranslation(closest.getContactPoint());
                Quaternion q = new Quaternion();
                q.lookAt(closest.getContactNormal(), Vector3f.UNIT_Y);
                this.myArrowMark.setLocalRotation(q);
                DemoYouPickStuff.this.rootNode.attachChild((Spatial)this.myArrowMark);
            } else {
                DemoYouPickStuff.this.rootNode.detachChild((Spatial)this.myArrowMark);
            }
        }
    }
}

