/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl;

import com.jme3.app.state.AppState;
import com.jme3.asset.AssetKey;
import com.jme3.asset.plugins.HttpZipLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.MaterialList;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.plugins.ogre.OgreMeshKey;
import java.io.File;
import org.cogchar.demo.render.opengl.UnfinishedDemoApp;

public class DemoYourQuakeLevelWWF
extends UnfinishedDemoApp
implements ActionListener {
    static String LOCAL_SCENE_PATH = "jme_asset_zips/quake3level.zip";
    static String HTTP_SCENE_PATH = "http://jmonkeyengine.googlecode.com/files/quake3level.zip";
    private BulletAppState bulletAppState;
    private Node gameLevel;
    private PhysicsCharacter player;
    private Vector3f walkDirection = new Vector3f();
    private static boolean useHttp = false;
    private boolean left = false;
    private boolean right = false;
    private boolean up = false;
    private boolean down = false;

    public static void main(String[] args) {
        File file = new File(LOCAL_SCENE_PATH);
        if (!file.exists()) {
            useHttp = true;
        }
        DemoYourQuakeLevelWWF app = new DemoYourQuakeLevelWWF();
        app.start();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        this.flyCam.setMoveSpeed(100.0f);
        this.setupKeys();
        this.cam.setFrustumFar(2000.0f);
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.White.clone().multLocal(2.0f));
        dl.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalize());
        this.rootNode.addLight((Light)dl);
        AmbientLight am = new AmbientLight();
        am.setColor(ColorRGBA.White.mult(2.0f));
        this.rootNode.addLight((Light)am);
        if (useHttp) {
            this.assetManager.registerLocator(HTTP_SCENE_PATH, HttpZipLocator.class.getName());
        } else {
            this.assetManager.registerLocator(LOCAL_SCENE_PATH, ZipLocator.class.getName());
        }
        MaterialList matList = (MaterialList)this.assetManager.loadAsset("Scene.material");
        OgreMeshKey key = new OgreMeshKey("main.meshxml", matList);
        this.gameLevel = (Node)this.assetManager.loadAsset((AssetKey)key);
        this.gameLevel.setLocalScale(0.1f);
        this.gameLevel.addControl((Control)new RigidBodyControl(0.0f));
        this.player = new PhysicsCharacter((CollisionShape)new SphereCollisionShape(5.0f), 0.01f);
        this.player.setJumpSpeed(20.0f);
        this.player.setFallSpeed(30.0f);
        this.player.setGravity(30.0f);
        this.player.setPhysicsLocation(new Vector3f(60.0f, 10.0f, -60.0f));
        this.rootNode.attachChild((Spatial)this.gameLevel);
        this.getPhysicsSpace().addAll((Spatial)this.gameLevel);
        this.getPhysicsSpace().add((Object)this.player);
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    public void simpleUpdate(float tpf) {
        Vector3f camDir = this.cam.getDirection().clone().multLocal(0.6f);
        Vector3f camLeft = this.cam.getLeft().clone().multLocal(0.4f);
        this.walkDirection.set(0.0f, 0.0f, 0.0f);
        if (this.left) {
            this.walkDirection.addLocal(camLeft);
        }
        if (this.right) {
            this.walkDirection.addLocal(camLeft.negate());
        }
        if (this.up) {
            this.walkDirection.addLocal(camDir);
        }
        if (this.down) {
            this.walkDirection.addLocal(camDir.negate());
        }
        this.player.setWalkDirection(this.walkDirection);
        this.cam.setLocation(this.player.getPhysicsLocation());
    }

    private void setupKeys() {
        this.inputManager.addMapping("Lefts", new Trigger[]{new KeyTrigger(30)});
        this.inputManager.addMapping("Rights", new Trigger[]{new KeyTrigger(32)});
        this.inputManager.addMapping("Ups", new Trigger[]{new KeyTrigger(17)});
        this.inputManager.addMapping("Downs", new Trigger[]{new KeyTrigger(31)});
        this.inputManager.addMapping("Space", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addListener((InputListener)this, new String[]{"Lefts"});
        this.inputManager.addListener((InputListener)this, new String[]{"Rights"});
        this.inputManager.addListener((InputListener)this, new String[]{"Ups"});
        this.inputManager.addListener((InputListener)this, new String[]{"Downs"});
        this.inputManager.addListener((InputListener)this, new String[]{"Space"});
    }

    public void onAction(String binding, boolean value, float tpf) {
        if (binding.equals("Lefts")) {
            this.left = value;
        } else if (binding.equals("Rights")) {
            this.right = value;
        } else if (binding.equals("Ups")) {
            this.up = value;
        } else if (binding.equals("Downs")) {
            this.down = value;
        } else if (binding.equals("Space")) {
            this.player.jump();
        }
    }
}

