/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl.brick;

import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.shadow.BasicShadowRenderer;
import com.jme3.shadow.PssmShadowRenderer;
import org.cogchar.render.app.core.CogcharPresumedApp;
import org.cogchar.render.opengl.optic.MatFactory;
import org.cogchar.render.sys.context.CogcharRenderContext;
import org.cogchar.render.sys.registry.RenderRegistryClient;

public class BrickApp
extends CogcharPresumedApp {
    protected Material myBrickMat;
    protected Material myRockMat;
    protected Material myPondMat;
    protected BulletAppState myPhysAppState;
    protected SceneProcessor myShadowRenderer;

    protected CogcharRenderContext makeCogcharRenderContext() {
        BA_RenderContext rc = new BA_RenderContext();
        return rc;
    }

    protected PhysicsSpace getPhysicsSpace() {
        return this.myPhysAppState.getPhysicsSpace();
    }

    protected void addShadowProcessor(SceneProcessor shadowProcessor) {
        this.rootNode.setShadowMode(RenderQueue.ShadowMode.Off);
        this.viewPort.addProcessor(shadowProcessor);
        this.myShadowRenderer = shadowProcessor;
    }

    protected void initPssmShadowRenderer() {
        PssmShadowRenderer shadowRenderer = new PssmShadowRenderer(this.assetManager, 1024, 2);
        shadowRenderer.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        shadowRenderer.setLambda(0.55f);
        shadowRenderer.setShadowIntensity(0.6f);
        shadowRenderer.setCompareMode(PssmShadowRenderer.CompareMode.Hardware);
        shadowRenderer.setFilterMode(PssmShadowRenderer.FilterMode.PCF4);
        this.addShadowProcessor((SceneProcessor)shadowRenderer);
    }

    protected void initBasicShadowRenderer() {
        BasicShadowRenderer bsr = new BasicShadowRenderer(this.assetManager, 256);
        bsr.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        this.addShadowProcessor((SceneProcessor)bsr);
    }

    public void initFloorBowlWall() {
        Box floorBox = new Box(Vector3f.ZERO, 10.0f, 0.1f, 5.0f);
        floorBox.scaleTextureCoordinates(new Vector2f(3.0f, 6.0f));
        Geometry floor_geo = new Geometry("Floor", (Mesh)floorBox);
        floor_geo.setMaterial(this.myPondMat);
        floor_geo.setShadowMode(RenderQueue.ShadowMode.Receive);
        floor_geo.setLocalTranslation(0.0f, -0.1f, 0.0f);
        this.makePhysicalObjControlAndAttachToRoot(floor_geo, 0.0f, null);
    }

    protected void attachPhysicalObjToRoot(Geometry geom, RigidBodyControl rbc, boolean attachAsControl) {
        if (attachAsControl) {
            geom.addControl((Control)rbc);
        }
        this.rootNode.attachChild((Spatial)geom);
        this.getPhysicsSpace().add((Object)rbc);
    }

    protected void attachPhysicalObjToRoot(Geometry geom) {
        this.rootNode.attachChild((Spatial)geom);
        this.getPhysicsSpace().add((Object)geom);
    }

    protected void makePhysicalObjControlAndAttachToRoot(Geometry geom, float mass, Float friction) {
        RigidBodyControl rbc = new RigidBodyControl(mass);
        this.attachPhysicalObjToRoot(geom, rbc, true);
        if (friction != null) {
            rbc.setFriction(friction.floatValue());
        }
    }

    class BA_RenderContext
    extends CogcharRenderContext {
        BA_RenderContext() {
        }

        public void completeInit() {
            BrickApp.this.myPhysAppState = new BulletAppState();
            this.initMaterials();
        }

        protected void initMaterials() {
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            MatFactory mf = rrc.getOpticMaterialFacade(null, null);
            BrickApp.this.myBrickMat = mf.getBrickWallMat();
            BrickApp.this.myRockMat = mf.makeRockMat();
            BrickApp.this.myPondMat = mf.getPondMat();
        }
    }
}

