/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl.brick;

import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.system.AppSettings;
import org.cogchar.demo.render.opengl.brick.BrickApp;
import org.cogchar.render.app.bony.BonyGameFeatureAdapter;
import org.cogchar.render.goody.physical.LaunchableCollidingRigidBodyControl;
import org.cogchar.render.sys.registry.RenderRegistryClient;

public class DemoYouBombBrickTowerWithPssmShadows
extends BrickApp {
    int bricksPerLayer = 8;
    int brickLayers = 30;
    static float brickWidth = 0.75f;
    static float brickHeight = 0.25f;
    static float brickDepth = 0.25f;
    float radius = 3.0f;
    private Sphere myRockSphere;
    private Box myBrickBox;
    private SphereCollisionShape myRockSphereColShape;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("shoot") && !keyPressed) {
                Geometry bulletg = new Geometry("bullet", (Mesh)DemoYouBombBrickTowerWithPssmShadows.this.myRockSphere);
                bulletg.setMaterial(DemoYouBombBrickTowerWithPssmShadows.this.myRockMat);
                bulletg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                bulletg.setLocalTranslation(DemoYouBombBrickTowerWithPssmShadows.this.cam.getLocation());
                LaunchableCollidingRigidBodyControl bulletNode = new LaunchableCollidingRigidBodyControl(DemoYouBombBrickTowerWithPssmShadows.this.assetManager, (CollisionShape)DemoYouBombBrickTowerWithPssmShadows.this.myRockSphereColShape, 1.0f);
                bulletNode.setLinearVelocity(DemoYouBombBrickTowerWithPssmShadows.this.cam.getDirection().mult(25.0f));
                bulletg.addControl((Control)bulletNode);
                DemoYouBombBrickTowerWithPssmShadows.this.rootNode.attachChild((Spatial)bulletg);
                DemoYouBombBrickTowerWithPssmShadows.this.getPhysicsSpace().add((Object)bulletNode);
            }
        }
    };

    public static void main(String[] args) {
        DemoYouBombBrickTowerWithPssmShadows f = new DemoYouBombBrickTowerWithPssmShadows();
        f.start();
    }

    public void simpleInitApp() {
        super.simpleInitApp();
        this.myPhysAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        this.stateManager.attach((AppState)this.myPhysAppState);
        this.myRockSphere = new Sphere(32, 32, 0.4f, true, false);
        this.myRockSphere.setTextureMode(Sphere.TextureMode.Projected);
        this.myRockSphereColShape = new SphereCollisionShape(0.4f);
        this.myBrickBox = new Box(Vector3f.ZERO, brickWidth, brickHeight, brickDepth);
        this.myBrickBox.scaleTextureCoordinates(new Vector2f(1.0f, 0.5f));
        this.initTower();
        this.initFloorBombTowerPssm();
        BonyGameFeatureAdapter.initCrossHairs((AppSettings)this.settings, (RenderRegistryClient)this.getRenderContext().getRenderRegistryClient());
        this.cam.setLocation(new Vector3f(0.0f, 25.0f, 8.0f));
        this.cam.lookAt(Vector3f.ZERO, new Vector3f(0.0f, 1.0f, 0.0f));
        this.cam.setFrustumFar(80.0f);
        this.inputManager.addMapping("shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"shoot"});
        this.initPssmShadowRenderer();
    }

    public void initTower() {
        float brickMass = 1.5f;
        float brickFrict = 1.6f;
        double tempX = 0.0;
        double tempY = 0.0;
        double tempZ = 0.0;
        float brickAngle = 0.0f;
        for (int i = 0; i < this.brickLayers; ++i) {
            tempY = i != 0 ? (tempY += (double)(brickHeight * 2.0f)) : (double)brickHeight;
            brickAngle = 360.0f / (float)this.bricksPerLayer * (float)i / 2.0f;
            for (int j = 0; j < this.bricksPerLayer; ++j) {
                tempZ = Math.cos(Math.toRadians(brickAngle)) * (double)this.radius;
                tempX = Math.sin(Math.toRadians(brickAngle)) * (double)this.radius;
                System.out.println("x=" + (float)tempX + " y=" + (float)tempY + " z=" + (float)tempZ);
                Vector3f vt = new Vector3f((float)tempX, (float)tempY, (float)tempZ);
                if (i == this.brickLayers - 1) {
                    if (j % 2 == 0) {
                        this.addBrickToTower(vt, brickAngle, brickMass, brickFrict);
                    }
                } else {
                    this.addBrickToTower(vt, brickAngle, brickMass, brickFrict);
                }
                brickAngle = (float)((double)brickAngle + 360.0 / (double)this.bricksPerLayer);
            }
        }
    }

    protected void initFloorBombTowerPssm() {
        Box floorBox = new Box(Vector3f.ZERO, 10.0f, 0.1f, 5.0f);
        floorBox.scaleTextureCoordinates(new Vector2f(3.0f, 6.0f));
        Geometry floor = new Geometry("floor", (Mesh)floorBox);
        floor.setMaterial(this.myPondMat);
        floor.setShadowMode(RenderQueue.ShadowMode.Receive);
        floor.setLocalTranslation(0.0f, 0.0f, 0.0f);
        this.makePhysicalObjControlAndAttachToRoot(floor, 0.0f, null);
    }

    protected void addBrickToTower(Vector3f localTrans, float brickAngle, float mass, float friction) {
        Geometry reBoxg = new Geometry("brick", (Mesh)this.myBrickBox);
        reBoxg.setMaterial(this.myBrickMat);
        reBoxg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        reBoxg.setLocalTranslation(localTrans);
        reBoxg.rotate(0.0f, (float)Math.toRadians(brickAngle), 0.0f);
        reBoxg.addControl((Control)new RigidBodyControl(mass));
        ((RigidBodyControl)reBoxg.getControl(RigidBodyControl.class)).setFriction(friction);
        this.attachPhysicalObjToRoot(reBoxg);
    }
}

