/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl.brick;

import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.system.AppSettings;
import org.cogchar.demo.render.opengl.brick.BrickApp;
import org.cogchar.render.app.bony.BonyGameFeatureAdapter;
import org.cogchar.render.goody.physical.LaunchableCollidingRigidBodyControl;
import org.cogchar.render.sys.registry.RenderRegistryClient;

public class DemoYouBombBrickWallWithBasicShadows
extends BrickApp {
    static float bLength = 0.48f;
    static float bWidth = 0.24f;
    static float bHeight = 0.12f;
    private static Sphere myRockSphere;
    private static Box myBrickBox;
    private static SphereCollisionShape myRockColShape;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("shoot") && !keyPressed) {
                Geometry bulletg = new Geometry("bullet", (Mesh)myRockSphere);
                bulletg.setMaterial(DemoYouBombBrickWallWithBasicShadows.this.myRockMat);
                bulletg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                bulletg.setLocalTranslation(DemoYouBombBrickWallWithBasicShadows.this.cam.getLocation());
                SphereCollisionShape bulletCollisionShape = new SphereCollisionShape(0.4f);
                LaunchableCollidingRigidBodyControl bulletNode = new LaunchableCollidingRigidBodyControl(DemoYouBombBrickWallWithBasicShadows.this.assetManager, (CollisionShape)bulletCollisionShape, 1.0f);
                bulletNode.setLinearVelocity(DemoYouBombBrickWallWithBasicShadows.this.cam.getDirection().mult(25.0f));
                bulletg.addControl((Control)bulletNode);
                DemoYouBombBrickWallWithBasicShadows.this.rootNode.attachChild((Spatial)bulletg);
                DemoYouBombBrickWallWithBasicShadows.this.getPhysicsSpace().add((Object)bulletNode);
            }
            if (name.equals("gc") && !keyPressed) {
                System.gc();
            }
        }
    };

    public static void main(String[] args) {
        DemoYouBombBrickWallWithBasicShadows f = new DemoYouBombBrickWallWithBasicShadows();
        f.start();
    }

    public void simpleInitApp() {
        super.simpleInitApp();
        this.myPhysAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        this.stateManager.attach((AppState)this.myPhysAppState);
        myRockSphere = new Sphere(32, 32, 0.4f, true, false);
        myRockSphere.setTextureMode(Sphere.TextureMode.Projected);
        myRockColShape = new SphereCollisionShape(0.4f);
        myBrickBox = new Box(Vector3f.ZERO, bLength, bHeight, bWidth);
        myBrickBox.scaleTextureCoordinates(new Vector2f(1.0f, 0.5f));
        this.initWall();
        this.initFloorBombWallBasic();
        BonyGameFeatureAdapter.initCrossHairs((AppSettings)this.settings, (RenderRegistryClient)this.getRenderContext().getRenderRegistryClient());
        this.cam.setLocation(new Vector3f(0.0f, 6.0f, 6.0f));
        this.cam.lookAt(Vector3f.ZERO, new Vector3f(0.0f, 1.0f, 0.0f));
        this.cam.setFrustumFar(15.0f);
        this.inputManager.addMapping("shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"shoot"});
        this.inputManager.addMapping("gc", new Trigger[]{new KeyTrigger(45)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"gc"});
        this.initBasicShadowRenderer();
    }

    public void initWall() {
        float startpt = bLength / 4.0f;
        float height = 0.0f;
        for (int j = 0; j < 15; ++j) {
            for (int i = 0; i < 4; ++i) {
                Vector3f vt = new Vector3f((float)i * bLength * 2.0f + startpt, bHeight + height, 0.0f);
                this.addBrickToWall(vt);
            }
            startpt = -startpt;
            height += 2.0f * bHeight;
        }
    }

    public void initFloorBombWallBasic() {
        Box floorBox = new Box(Vector3f.ZERO, 10.0f, 0.1f, 5.0f);
        floorBox.scaleTextureCoordinates(new Vector2f(3.0f, 6.0f));
        Geometry floor = new Geometry("floor", (Mesh)floorBox);
        floor.setMaterial(this.myPondMat);
        floor.setShadowMode(RenderQueue.ShadowMode.Receive);
        floor.setLocalTranslation(0.0f, -0.1f, 0.0f);
        RigidBodyControl rbc = new RigidBodyControl((CollisionShape)new BoxCollisionShape(new Vector3f(10.0f, 0.1f, 5.0f)), 0.0f);
        this.attachPhysicalObjToRoot(floor, rbc, true);
    }

    public void addBrickToWall(Vector3f ori) {
        Geometry reBoxg = new Geometry("brick", (Mesh)myBrickBox);
        reBoxg.setMaterial(this.myBrickMat);
        reBoxg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        reBoxg.setLocalTranslation(ori);
        this.makePhysicalObjControlAndAttachToRoot(reBoxg, 1.5f, Float.valueOf(0.6f));
    }
}

