/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl.jme3;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.util.CollisionShapeFactory;
import com.jme3.font.BitmapText;
import com.jme3.input.ChaseCamera;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.shadow.PssmShadowRenderer;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.ImageBasedHeightMap;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import java.util.ArrayList;
import org.cogchar.demo.render.opengl.jme3.ExpodingProjectileControl;
import org.cogchar.demo.render.opengl.jme3.PhysicsHoverControl;

public class DemoHovercraftFliesAndShoots
extends SimpleApplication
implements AnalogListener,
ActionListener {
    private BulletAppState bulletAppState;
    private PhysicsHoverControl hoverControl;
    private Spatial spaceCraft;
    TerrainQuad terrain;
    Material matRock;
    boolean wireframe = false;
    protected BitmapText hintText;
    PointLight pl;
    Geometry lightMdl;
    Geometry collisionMarker;

    public static void main(String[] args) {
        DemoHovercraftFliesAndShoots app = new DemoHovercraftFliesAndShoots();
        app.start();
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    private void setupKeys() {
        this.inputManager.addMapping("Lefts", new Trigger[]{new KeyTrigger(30)});
        this.inputManager.addMapping("Rights", new Trigger[]{new KeyTrigger(32)});
        this.inputManager.addMapping("Ups", new Trigger[]{new KeyTrigger(17)});
        this.inputManager.addMapping("Downs", new Trigger[]{new KeyTrigger(31)});
        this.inputManager.addMapping("Space", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addMapping("Reset", new Trigger[]{new KeyTrigger(28)});
        this.inputManager.addListener((InputListener)this, new String[]{"Lefts"});
        this.inputManager.addListener((InputListener)this, new String[]{"Rights"});
        this.inputManager.addListener((InputListener)this, new String[]{"Ups"});
        this.inputManager.addListener((InputListener)this, new String[]{"Downs"});
        this.inputManager.addListener((InputListener)this, new String[]{"Space"});
        this.inputManager.addListener((InputListener)this, new String[]{"Reset"});
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        this.stateManager.attach((AppState)this.bulletAppState);
        this.bulletAppState.getPhysicsSpace().setAccuracy(0.033333335f);
        this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)"Textures/Sky/Bright/BrightSky.dds", (boolean)false));
        PssmShadowRenderer pssmr = new PssmShadowRenderer(this.assetManager, 2048, 3);
        pssmr.setDirection(new Vector3f(-0.5f, -0.3f, -0.3f).normalizeLocal());
        pssmr.setLambda(0.55f);
        pssmr.setShadowIntensity(0.6f);
        pssmr.setCompareMode(PssmShadowRenderer.CompareMode.Hardware);
        pssmr.setFilterMode(PssmShadowRenderer.FilterMode.Bilinear);
        this.viewPort.addProcessor((SceneProcessor)pssmr);
        this.setupKeys();
        this.createTerrain();
        this.buildPlayer();
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(new ColorRGBA(1.0f, 0.94f, 0.8f, 1.0f).multLocal(1.3f));
        dl.setDirection(new Vector3f(-0.5f, -0.3f, -0.3f).normalizeLocal());
        this.rootNode.addLight((Light)dl);
        Vector3f lightDir2 = new Vector3f(0.70518064f, 0.5902297f, -0.39287305f);
        DirectionalLight dl2 = new DirectionalLight();
        dl2.setColor(new ColorRGBA(0.7f, 0.85f, 1.0f, 1.0f));
        dl2.setDirection(lightDir2);
        this.rootNode.addLight((Light)dl2);
    }

    private void buildPlayer() {
        this.spaceCraft = this.assetManager.loadModel("Models/HoverTank/Tank2.mesh.xml");
        CollisionShape colShape = CollisionShapeFactory.createDynamicMeshShape((Spatial)this.spaceCraft);
        this.spaceCraft.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.spaceCraft.setLocalTranslation(new Vector3f(-140.0f, 14.0f, -23.0f));
        this.spaceCraft.setLocalRotation(new Quaternion(new float[]{0.0f, 0.01f, 0.0f}));
        this.hoverControl = new PhysicsHoverControl(colShape, 500.0f);
        this.hoverControl.setCollisionGroup(2);
        this.spaceCraft.addControl((Control)this.hoverControl);
        this.rootNode.attachChild(this.spaceCraft);
        this.getPhysicsSpace().add((Object)this.hoverControl);
        ChaseCamera chaseCam = new ChaseCamera(this.cam, this.inputManager);
        this.spaceCraft.addControl((Control)chaseCam);
        this.flyCam.setEnabled(false);
    }

    public void makeMissile() {
        Vector3f pos = this.spaceCraft.getWorldTranslation().clone();
        Quaternion rot = this.spaceCraft.getWorldRotation();
        Vector3f dir = rot.getRotationColumn(2);
        Spatial missile = this.assetManager.loadModel("Models/SpaceCraft/Rocket.mesh.xml");
        missile.scale(0.5f);
        missile.rotate(0.0f, (float)Math.PI, 0.0f);
        missile.updateGeometricState();
        BoundingBox box = (BoundingBox)missile.getWorldBound();
        Vector3f extent = box.getExtent(null);
        BoxCollisionShape boxShape = new BoxCollisionShape(extent);
        missile.setName("Missile");
        missile.rotate(rot);
        missile.setLocalTranslation(pos.addLocal(0.0f, extent.y * 4.5f, 0.0f));
        missile.setLocalRotation(this.hoverControl.getPhysicsRotation());
        missile.setShadowMode(RenderQueue.ShadowMode.Cast);
        ExpodingProjectileControl control = new ExpodingProjectileControl(this.assetManager, (CollisionShape)boxShape, 20.0f);
        control.setLinearVelocity(dir.mult(100.0f));
        control.setCollisionGroup(4);
        missile.addControl((Control)control);
        this.rootNode.attachChild(missile);
        this.getPhysicsSpace().add((Object)missile);
    }

    public void onAnalog(String binding, float value, float tpf) {
    }

    public void onAction(String binding, boolean value, float tpf) {
        if (binding.equals("Lefts")) {
            this.hoverControl.steer(value ? 50.0f : 0.0f);
        } else if (binding.equals("Rights")) {
            this.hoverControl.steer(value ? -50.0f : 0.0f);
        } else if (binding.equals("Ups")) {
            this.hoverControl.accelerate(value ? 100.0f : 0.0f);
        } else if (binding.equals("Downs")) {
            this.hoverControl.accelerate(value ? -100.0f : 0.0f);
        } else if (binding.equals("Reset")) {
            if (value) {
                System.out.println("Reset");
                this.hoverControl.setPhysicsLocation(new Vector3f(-140.0f, 14.0f, -23.0f));
                this.hoverControl.setPhysicsRotation(new Matrix3f());
                this.hoverControl.clearForces();
            }
        } else if (binding.equals("Space") && value) {
            this.makeMissile();
        }
    }

    public void updateCamera() {
        this.rootNode.updateGeometricState();
        Vector3f pos = this.spaceCraft.getWorldTranslation().clone();
        Quaternion rot = this.spaceCraft.getWorldRotation();
        Vector3f dir = rot.getRotationColumn(2);
        Vector3f camPos = new Vector3f(dir);
        camPos.setY(0.0f);
        camPos.normalizeLocal();
        camPos.negateLocal();
        camPos.multLocal(15.0f);
        camPos.setY(2.0f);
        camPos.addLocal(pos);
        this.cam.setLocation(camPos);
        Vector3f lookAt = new Vector3f(dir);
        lookAt.multLocal(7.0f);
        lookAt.addLocal(pos);
        this.cam.lookAt(lookAt, Vector3f.UNIT_Y);
    }

    public void simpleUpdate(float tpf) {
    }

    private void createTerrain() {
        this.matRock = new Material(this.assetManager, "Common/MatDefs/Terrain/TerrainLighting.j3md");
        this.matRock.setBoolean("useTriPlanarMapping", false);
        this.matRock.setBoolean("WardIso", true);
        this.matRock.setTexture("AlphaMap", this.assetManager.loadTexture("Textures/Terrain/splat/alphamap.png"));
        Texture heightMapImage = this.assetManager.loadTexture("Textures/Terrain/splat/mountains512.png");
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap", grass);
        this.matRock.setFloat("DiffuseMap_0_scale", 64.0f);
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap_1", dirt);
        this.matRock.setFloat("DiffuseMap_1_scale", 16.0f);
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/splat/road.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap_2", rock);
        this.matRock.setFloat("DiffuseMap_2_scale", 128.0f);
        Texture normalMap0 = this.assetManager.loadTexture("Textures/Terrain/splat/grass_normal.jpg");
        normalMap0.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap1 = this.assetManager.loadTexture("Textures/Terrain/splat/dirt_normal.png");
        normalMap1.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap2 = this.assetManager.loadTexture("Textures/Terrain/splat/road_normal.png");
        normalMap2.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("NormalMap", normalMap0);
        this.matRock.setTexture("NormalMap_1", normalMap2);
        this.matRock.setTexture("NormalMap_2", normalMap2);
        ImageBasedHeightMap heightmap = null;
        try {
            heightmap = new ImageBasedHeightMap(heightMapImage.getImage(), 0.25f);
            heightmap.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.terrain = new TerrainQuad("terrain", 65, 513, heightmap.getHeightMap());
        ArrayList<Camera> cameras = new ArrayList<Camera>();
        cameras.add(this.getCamera());
        TerrainLodControl control = new TerrainLodControl((Terrain)this.terrain, cameras);
        this.terrain.addControl((Control)control);
        this.terrain.setMaterial(this.matRock);
        this.terrain.setLocalScale(new Vector3f(2.0f, 2.0f, 2.0f));
        this.terrain.setLocked(false);
        this.terrain.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.terrain.addControl((Control)new RigidBodyControl(0.0f));
        this.rootNode.attachChild((Spatial)this.terrain);
        this.getPhysicsSpace().addAll((Spatial)this.terrain);
    }
}

