/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.opengl.jme3;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.app.SimpleApplication;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.SkeletonDebugger;

public class DemoTwoSpinningNinjas
extends SimpleApplication
implements ActionListener {
    private AnimChannel channel1;
    private AnimChannel channel2;
    private String[] animNames;
    private float blendTime = 0.5f;
    private float lockAfterBlending = this.blendTime + 0.25f;
    private float blendingAnimationLock;

    public static void main(String[] args) {
        DemoTwoSpinningNinjas app = new DemoTwoSpinningNinjas();
        app.start();
    }

    public void onAction(String name, boolean value, float tpf) {
        if (name.equals("One") && value) {
            this.channel1.setAnim(this.animNames[4], this.blendTime);
            this.channel2.setAnim(this.animNames[4], 0.0f);
            this.channel1.setSpeed(0.25f);
            this.channel2.setSpeed(0.25f);
            this.blendingAnimationLock = this.lockAfterBlending;
        }
    }

    public void onPreUpdate(float tpf) {
    }

    public void onPostUpdate(float tpf) {
    }

    public void simpleUpdate(float tpf) {
        if (this.blendingAnimationLock > 0.0f) {
            this.blendingAnimationLock -= tpf;
        }
    }

    public void simpleInitApp() {
        this.inputManager.addMapping("One", new Trigger[]{new KeyTrigger(2)});
        this.inputManager.addListener((InputListener)this, new String[]{"One"});
        this.flyCam.setMoveSpeed(100.0f);
        this.cam.setLocation(new Vector3f(0.0f, 150.0f, -325.0f));
        this.cam.lookAt(new Vector3f(0.0f, 100.0f, 0.0f), Vector3f.UNIT_Y);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-0.1f, -0.7f, 1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.rootNode.addLight((Light)dl);
        Node model1 = (Node)this.assetManager.loadModel("Models/Ninja/Ninja.mesh.xml");
        Node model2 = (Node)this.assetManager.loadModel("Models/Ninja/Ninja.mesh.xml");
        model1.setLocalTranslation(-60.0f, 0.0f, 0.0f);
        model2.setLocalTranslation(60.0f, 0.0f, 0.0f);
        AnimControl control1 = (AnimControl)model1.getControl(AnimControl.class);
        this.animNames = control1.getAnimationNames().toArray(new String[0]);
        this.channel1 = control1.createChannel();
        AnimControl control2 = (AnimControl)model2.getControl(AnimControl.class);
        this.channel2 = control2.createChannel();
        SkeletonDebugger skeletonDebug = new SkeletonDebugger("skeleton1", control1.getSkeleton());
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", ColorRGBA.Green);
        mat.getAdditionalRenderState().setDepthTest(false);
        skeletonDebug.setMaterial(mat);
        model1.attachChild((Spatial)skeletonDebug);
        skeletonDebug = new SkeletonDebugger("skeleton2", control2.getSkeleton());
        skeletonDebug.setMaterial(mat);
        model2.attachChild((Spatial)skeletonDebug);
        this.rootNode.attachChild((Spatial)model1);
        this.rootNode.attachChild((Spatial)model2);
    }
}

