/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.demo.render.trial;

import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.font.Rectangle;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.system.AppSettings;
import org.cogchar.demo.render.opengl.UnfinishedDemoApp;
import org.cogchar.render.app.bony.BonyGameFeatureAdapter;
import org.cogchar.render.sys.context.CogcharRenderContext;
import org.cogchar.render.sys.context.ConfiguredPhysicalModularRenderContext;
import org.cogchar.render.sys.context.CoreFeatureAdapter;
import org.cogchar.render.sys.registry.RenderRegistryClient;

public class TrialBalloon
extends UnfinishedDemoApp {
    public static void main(String[] args) {
        TrialBalloon app = new TrialBalloon();
        app.start();
    }

    @Override
    protected CogcharRenderContext makeCogcharRenderContext() {
        TB_RenderContext rc = new TB_RenderContext();
        return rc;
    }

    public void simpleInitApp() {
        super.simpleInitApp();
        this.flyCam.setMoveSpeed(20.0f);
    }

    public class TB_RenderContext
    extends ConfiguredPhysicalModularRenderContext {
        Node myMainNode;

        public void completeInit() {
            this.myMainNode = new Node("my_main");
            TrialBalloon.this.rootNode.attachChild((Spatial)this.myMainNode);
            BonyGameFeatureAdapter.initCrossHairs((AppSettings)TrialBalloon.this.settings, (RenderRegistryClient)this.getRenderRegistryClient());
            TrialBalloon.this.setupLight();
            BitmapText btSpatial = this.makeTextSpatial();
            this.myMainNode.attachChild((Spatial)btSpatial);
            BillboardControl bbCont = new BillboardControl();
            bbCont.setAlignment(BillboardControl.Alignment.Screen);
            btSpatial.addControl((Control)bbCont);
            TrialBalloon.this.viewPort.setBackgroundColor(ColorRGBA.Blue);
        }

        private BitmapText makeTextSpatial() {
            String txtB = "ABCDEFGHIKLMNOPQRSTUVWXYZ1234567890`~!@#$%^&*()-=_+[]\\;',./{}|:<>?";
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            BitmapText txtSpatial = rrc.getSceneTextFacade(null).getScaledBitmapText(txtB, 1.0f);
            Rectangle rect = new Rectangle(0.0f, 0.0f, 6.0f, 3.0f);
            txtSpatial.setBox(rect);
            txtSpatial.setSize(1.0f);
            txtSpatial.setText(txtB);
            BitmapFont bf = txtSpatial.getFont();
            int pageCount = bf.getPageSize();
            System.out.println("Disabling culling for a total of " + pageCount + " font materials");
            for (int i = 0; i < pageCount; ++i) {
                Material fontMat = bf.getPage(i);
                fontMat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
            }
            return txtSpatial;
        }

        private void shedMoreLight() {
            ConfiguredPhysicalModularRenderContext cpmrc = (ConfiguredPhysicalModularRenderContext)TrialBalloon.this.getRenderContext();
            RenderRegistryClient rrc = cpmrc.getRenderRegistryClient();
            Vector3f otherLightDir = new Vector3f(0.1f, 0.7f, 1.0f).normalizeLocal();
            DirectionalLight odl = rrc.getOpticLightFacade(null).makeWhiteOpaqueDirectionalLight(otherLightDir);
            CoreFeatureAdapter.addLightToRootNode((CogcharRenderContext)cpmrc, (Light)odl);
        }
    }
}

