/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.outer.client;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import org.appdapter.core.log.BasicDebugger;
import org.cogchar.name.dir.SparqlPrefixDir;
import org.cogchar.outer.client.AgentRepoClient;
import org.slf4j.Logger;

public class TestOuterClientSOH
extends BasicDebugger {
    public static String dbpediaServiceURL = "http://dbpedia.org/sparql";
    public static String repoBaseURL = "http://localhost:8080/cchr_josk/";
    public static String repoBaseQryURL = repoBaseURL + "sparql/";
    public static String repoBaseUpdURL = repoBaseURL + "sparql-update/";
    public static String bookSvcURL = repoBaseQryURL + "books";
    public static String glueQryURL = repoBaseQryURL + "glue-ai";
    public static String glueUpdURL = repoBaseUpdURL + "glue-ai";
    AgentRepoClient myAgentRepoClient = new AgentRepoClient();
    static String PREFIX_FOAF = SparqlPrefixDir.PREFIX_FOAF;
    static String PREFIX_XSD = SparqlPrefixDir.PREFIX_XSD;
    static String PREFIX_DC = SparqlPrefixDir.PREFIX_DC;
    static String PREFIX_DBO = SparqlPrefixDir.PREFIX_DBO;
    static String PREFIX_DBP = SparqlPrefixDir.PREFIX_DBP;
    static String PREFIX_BOOKS = SparqlPrefixDir.PREFIX_BOOKS;
    static String PREFIX_CCRT = SparqlPrefixDir.PREFIX_CCRT;
    static String PREFIX_UA = SparqlPrefixDir.PREFIX_UA;
    static String dbpQ = PREFIX_DBO + PREFIX_FOAF + PREFIX_XSD + PREFIX_DBP + "SELECT ?name ?birth ?death ?person WHERE {\n" + "?person dbo:birthPlace :Berlin .   ?person dbo:birthDate ?birth .   ?person foaf:name ?name .\n" + "?person dbo:deathDate ?death .   FILTER (?birth < '1900-01-01'^^xsd:date) }";
    static String bookQ = PREFIX_BOOKS + PREFIX_DC + "SELECT ?book ?title  WHERE   { ?book dc:title ?title }";
    static String glueQ = PREFIX_CCRT + PREFIX_UA + "SELECT ?user ?password ?salt ?startPage WHERE { GRAPH ?qGraph { \n" + "?user a ccrt:userConfig; ua:password ?password; ua:salt ?salt; ua:homePage ?startPage.}}";
    static String glueUpSilly = PREFIX_CCRT + PREFIX_UA + PREFIX_DC + "INSERT DATA {  GRAPH   ccrt:user_access_sheet_22 { \n" + "<http://yeah/nutty> dc:title 'How to be revolting' ;    dc:creator 'Spart A. Cus'. }}\n";

    public static void main(String[] args) {
        TestOuterClientSOH test = new TestOuterClientSOH();
        test.runTests();
    }

    public TestOuterClientSOH() {
        this.forceLog4jConfig();
    }

    public void runTests() {
        this.runRemoteSparqlSelectAndPrintResults(bookSvcURL, bookQ);
        this.runRemoteSparqlSelectAndPrintResults(glueQryURL, glueQ);
        this.myAgentRepoClient.execRemoteSparqlUpdate(glueUpdURL, glueUpSilly, true);
    }

    public void runRemoteSparqlSelectAndPrintResults(String svcUrl, String queryTxt) {
        Logger log = this.getLogger();
        ResultSet resSet = this.myAgentRepoClient.execRemoteSparqlSelect(svcUrl, queryTxt);
        ResultSetRewindable rewindableResSet = ResultSetFactory.makeRewindable((ResultSet)resSet);
        String resultXML = ResultSetFormatter.asXMLString((ResultSet)rewindableResSet);
        log.info("ResultSet as XML: \n" + resultXML);
    }
}

