/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.outer.client;

import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.appdapter.core.log.BasicDebugger;
import org.cogchar.outer.client.WebDataDumper;
import org.slf4j.Logger;

public class WebDataClient
extends BasicDebugger {
    protected HttpClient myHttpCli = new DefaultHttpClient();

    public String execGet(String url, boolean debugFlag, String rqSummary) {
        String resultText = null;
        try {
            resultText = WebDataClient.execGetRequest(this.myHttpCli, url, this.getLogger(), debugFlag, rqSummary);
        }
        catch (Throwable t) {
            this.getLogger().error("Problem during execGet", t);
        }
        return resultText;
    }

    protected static String execGetRequest(HttpClient httpCli, String url, Logger log, boolean debugFlag, String rqSummary) throws Throwable {
        String resultText = null;
        HttpGet getReq = new HttpGet(url);
        HttpResponse response = httpCli.execute((HttpUriRequest)getReq);
        resultText = WebDataClient.extractResponseEntityText(response, log, debugFlag, rqSummary);
        return resultText;
    }

    public String execPost(String url, List<NameValuePair> nvps, boolean debugFlag) {
        String resultText = null;
        try {
            resultText = WebDataClient.execPostRequest(this.myHttpCli, url, nvps, this.getLogger(), debugFlag);
        }
        catch (Throwable t) {
            this.getLogger().error("Problem during execGet", t);
        }
        return resultText;
    }

    protected static String execPostRequest(HttpClient httpCli, String postURL, List<NameValuePair> nvps, Logger log, boolean debugFlag) throws Throwable {
        log.info("Building post request for URL: " + postURL);
        HttpPost postReq = new HttpPost(postURL);
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(nvps, "UTF-8");
        postReq.setEntity((HttpEntity)formEntity);
        String rqSummary = "Posting [URL=" + postURL + "]";
        if (debugFlag) {
            rqSummary = rqSummary + ", pairs=[" + nvps + "]";
            WebDataDumper.dumpRequestInfo(postReq, log);
        }
        HttpResponse response = httpCli.execute((HttpUriRequest)postReq);
        log.debug("HttpClient returned a response, now extracting");
        String resultText = WebDataClient.extractResponseEntityText(response, log, debugFlag, rqSummary);
        if (debugFlag) {
            WebDataDumper.dumpResponseInfo(response, rqSummary, resultText, log);
        }
        return resultText;
    }

    protected static String extractResponseEntityText(HttpResponse response, Logger log, boolean debugFlag, String rqSummary) throws Throwable {
        String entityText = null;
        HttpEntity resEntity = response.getEntity();
        if (resEntity != null) {
            if (debugFlag) {
                log.debug("Got response entity: " + resEntity);
                log.debug("Response content length: " + resEntity.getContentLength());
                log.debug("Chunked?: " + resEntity.isChunked());
            }
            entityText = EntityUtils.toString((HttpEntity)resEntity);
            resEntity.consumeContent();
        } else {
            log.warn("No entity attached to response to request: " + rqSummary);
        }
        return entityText;
    }
}

