/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.outer.client.goody;

import java.util.Random;
import org.appdapter.core.log.BasicDebugger;
import org.appdapter.core.name.FreeIdent;
import org.appdapter.core.name.Ident;
import org.cogchar.api.thing.BasicThingActionSpec;
import org.cogchar.api.thing.BasicTypedValueMap;
import org.cogchar.api.thing.ThingActionSpec;
import org.cogchar.api.thing.TypedValueMap;
import org.cogchar.impl.thing.ConcreteTVM;
import org.cogchar.impl.thing.FancyThingModelWriter;
import org.cogchar.name.goody.GoodyNames;
import org.cogchar.outer.client.AgentRepoClient;
import org.cogchar.outer.client.TestOuterClientSOH;
import org.cogchar.outer.client.goody.GoodyActionParamWriter;
import org.slf4j.Logger;

public class TestRemoteBitBoxes
extends BasicDebugger {
    AgentRepoClient myAgentRepoClient = new AgentRepoClient();
    static float TEST_INIT_X = 30.0f;
    static float TEST_INIT_Y = 15.0f;
    static float TEST_INIT_Z = 10.0f;
    private static String goodyGraphQN = "ccrt:thing_sheet_22";
    private static String boxBaseURI = "http://dummy.org/bitbox#num_";

    public static void main(String[] args) {
        TestRemoteBitBoxes tester = new TestRemoteBitBoxes();
        tester.doBitBoxTest(0);
    }

    public TestRemoteBitBoxes() {
        this.forceLog4jConfig();
    }

    public void doBitBoxTest(int outerLoopCount) {
        Random ran = new Random();
        Ident boxOneID = this.makeOneBitBox(ran, true);
        for (int outer = 0; outer < outerLoopCount; ++outer) {
            for (int i = 0; i < 100; ++i) {
                this.getLogger().info("Starting loop #" + outer + "." + i);
                float disp = (float)i / 10.0f;
                this.updateGoodyLocation(boxOneID, TEST_INIT_X + disp, TEST_INIT_Y + disp, TEST_INIT_Z + disp, ran, false);
            }
        }
    }

    public Ident makeOneBitBox(Random ran, boolean debugFlag) {
        ConcreteTVM btvm = new ConcreteTVM();
        GoodyActionParamWriter gapw = new GoodyActionParamWriter((BasicTypedValueMap)btvm);
        gapw.putLocation(TEST_INIT_X, TEST_INIT_Y, TEST_INIT_Z);
        gapw.putRotation(1.0f, 1.0f, 1.0f, 10.0f);
        gapw.putScale(4.0f);
        FreeIdent dummyBoxID = new FreeIdent(boxBaseURI + System.currentTimeMillis());
        this.sendBitBoxTAS((Ident)dummyBoxID, GoodyNames.ACTION_CREATE, (TypedValueMap)btvm, ran, debugFlag);
        return dummyBoxID;
    }

    public void updateGoodyLocation(Ident goodyID, float locX, float locY, float locZ, Random ran, boolean debugFlag) {
        ConcreteTVM btvm = new ConcreteTVM();
        GoodyActionParamWriter gapw = new GoodyActionParamWriter((BasicTypedValueMap)btvm);
        gapw.putLocation(locX, locY, locZ);
        this.sendBitBoxTAS(goodyID, GoodyNames.ACTION_MOVE, (TypedValueMap)btvm, ran, debugFlag);
    }

    public void sendBitBoxTAS(Ident tgtThingID, Ident verbID, TypedValueMap paramTVMap, Random ran, boolean debugFlag) {
        FreeIdent actRecID = new FreeIdent("action_#" + ran.nextInt());
        Ident tgtThingTypeID = GoodyNames.TYPE_BIT_BOX;
        Ident srcAgentID = null;
        BasicThingActionSpec btas = new BasicThingActionSpec((Ident)actRecID, tgtThingID, tgtThingTypeID, verbID, srcAgentID, paramTVMap);
        this.sendThingActionSpec((ThingActionSpec)btas, ran, debugFlag);
    }

    public void sendThingActionSpec(ThingActionSpec actionSpec, Random ran, boolean debugFlag) {
        Logger log = this.getLogger();
        log.info("Sending action spec: " + actionSpec);
        FancyThingModelWriter ftmw = new FancyThingModelWriter();
        String updateTxt = ftmw.writeTASpecToString(actionSpec, goodyGraphQN, ran);
        this.myAgentRepoClient.execRemoteSparqlUpdate(TestOuterClientSOH.glueUpdURL, updateTxt, debugFlag);
    }
}

