/*
 *  Copyright 2012 by The Cogchar Project (www.cogchar.org).
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.cogchar.render.sys.context;

import org.cogchar.blob.emit.RenderConfigEmitter;
import org.cogchar.render.sys.registry.BasicRenderRegistryClientImpl;
import org.cogchar.render.sys.registry.RenderRegistryClient;

/**
 * @author Stu B. <www.texpedient.com>
 */
public class ConfiguredPhysicalModularRenderContext extends PhysicalModularRenderContext {
	RenderConfigEmitter		myRCE;
	
	public ConfiguredPhysicalModularRenderContext(RenderRegistryClient rrc, RenderConfigEmitter rce) {
		super(rrc);
		myRCE = rce;
	}
	public ConfiguredPhysicalModularRenderContext(RenderRegistryClient rrc) { 
		this(rrc, new RenderConfigEmitter());
	}
	public ConfiguredPhysicalModularRenderContext() { 
		this(new BasicRenderRegistryClientImpl());
	}
	public RenderConfigEmitter getConfigEmitter() { 
		return myRCE;
	}
	@Override public void completeInit() {
		super.completeInit();
		CoreFeatureAdapter.unrolledInitDRC(this);
	}


	
}
