/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.metadata;

import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.comixedproject.metadata.MetadataAdaptorProvider;
import org.comixedproject.metadata.MetadataException;
import org.comixedproject.metadata.adaptors.MetadataAdaptor;
import org.springframework.stereotype.Component;

@Component
public class MetadataAdaptorRegistry {
    @Generated
    private static final Logger log = LogManager.getLogger(MetadataAdaptorRegistry.class);

    public List<MetadataAdaptorProvider> getAdaptors() {
        ServiceLoader<MetadataAdaptorProvider> loaders = ServiceLoader.load(MetadataAdaptorProvider.class);
        return loaders.stream().map(ServiceLoader.Provider::get).toList();
    }

    public MetadataAdaptor getAdaptor(String adaptorName) throws MetadataException {
        log.debug("Loading metadata adaptor: {}", (Object)adaptorName);
        Optional<MetadataAdaptorProvider> found = this.getAdaptors().stream().filter(adaptor -> adaptor.getName().equals(adaptorName)).findFirst();
        if (found.isEmpty()) {
            throw new MetadataException("No such metadata adaptor: " + adaptorName);
        }
        MetadataAdaptorProvider adaptor2 = found.get();
        log.debug("Found: {}", (Object)adaptor2.getName());
        return adaptor2.create();
    }
}

