/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.metadata.adaptors;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.comixedproject.metadata.MetadataException;
import org.comixedproject.metadata.adaptors.MetadataAdaptor;
import org.comixedproject.metadata.model.IssueMetadata;
import org.comixedproject.model.metadata.MetadataSource;
import org.comixedproject.model.metadata.MetadataSourceProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractMetadataAdaptor
implements MetadataAdaptor {
    @Generated
    private static final Logger log = LogManager.getLogger(AbstractMetadataAdaptor.class);
    private static final String VOLUMES_KEY = "volumes[%s]";
    private static final String ISSUE_KEY = "issues[%s-%s]";
    private static final String ISSUE_DETAILS_KEY = "issue[%s]";
    @Autowired
    protected ObjectMapper objectMapper;
    @NonNull
    private final String source;
    @NonNull
    private final String identifier;

    @Override
    public String getVolumeKey(String seriesName) {
        log.debug("Generating volume key for: {}", (Object)seriesName);
        return String.format(VOLUMES_KEY, seriesName.toUpperCase());
    }

    @Override
    public String getIssueKey(String volume, String issueNumber) {
        return String.format(ISSUE_KEY, volume, issueNumber.toUpperCase());
    }

    @Override
    public String getIssueDetailsKey(String issueId) {
        return String.format(ISSUE_DETAILS_KEY, issueId);
    }

    @Override
    public IssueMetadata getIssue(String volume, String issueNumber, MetadataSource metadataSource) throws MetadataException {
        String issue = issueNumber;
        while (!issue.isEmpty() && !issue.equals("0") && "123456789%ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(issue.toUpperCase().substring(0, 1)) == -1) {
            issue = issue.substring(1);
        }
        return this.doGetIssue(volume, issue, metadataSource);
    }

    protected String getSourcePropertyByName(Set<MetadataSourceProperty> properties, String name, boolean required) throws MetadataException {
        log.debug("Looking for metadata source property: property={} [required:{}]", (Object)name, (Object)required);
        Optional<MetadataSourceProperty> entry = properties.stream().filter(property -> property.getName().equals(name)).findFirst();
        if (entry.isEmpty() || !StringUtils.hasLength((String)entry.get().getValue())) {
            if (required) {
                throw new MetadataException("Missing required metadata source property: " + name);
            }
            log.debug("Property not found");
            return null;
        }
        String result = entry.get().getValue();
        log.debug("Found value: {}", (Object)result);
        return result;
    }

    protected abstract IssueMetadata doGetIssue(String var1, String var2, MetadataSource var3) throws MetadataException;

    @Generated
    public AbstractMetadataAdaptor(@NonNull String source, @NonNull String identifier) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        this.source = source;
        this.identifier = identifier;
    }

    @Override
    @NonNull
    @Generated
    public String getSource() {
        return this.source;
    }

    @Override
    @NonNull
    @Generated
    public String getIdentifier() {
        return this.identifier;
    }
}

