/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.batch;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.comixedproject.views.View;
import org.springframework.batch.core.JobExecution;

public class BatchProcessDetail {
    @JsonProperty(value="jobName")
    @JsonView(value={View.GenericObjectView.class})
    private String jobName;
    @JsonProperty(value="jobId")
    @JsonView(value={View.GenericObjectView.class})
    private long jobId;
    @JsonProperty(value="running")
    @JsonView(value={View.GenericObjectView.class})
    private boolean running;
    @JsonProperty(value="status")
    @JsonView(value={View.GenericObjectView.class})
    private String status;
    @JsonProperty(value="parameters")
    @JsonView(value={View.GenericObjectView.class})
    private Map<String, String> parameters = new HashMap<String, String>();
    @JsonProperty(value="createTime")
    @JsonView(value={View.GenericObjectView.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    private Date createTime;
    @JsonProperty(value="startTime")
    @JsonView(value={View.GenericObjectView.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    private Date startTime;
    @JsonProperty(value="endTime")
    @JsonView(value={View.GenericObjectView.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    private Date endTime;
    @JsonProperty(value="lastUpdateTime")
    @JsonView(value={View.GenericObjectView.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    private Date lastUpdateTime;
    @JsonProperty(value="exitStatus")
    @JsonView(value={View.GenericObjectView.class})
    private String exitStatus;
    @JsonProperty(value="errors")
    @JsonView(value={View.GenericObjectView.class})
    private String errors;

    public static BatchProcessDetail from(JobExecution jobExecution) {
        BatchProcessDetail result = new BatchProcessDetail();
        result.setJobName(jobExecution.getJobInstance().getJobName());
        result.setJobId(jobExecution.getJobId());
        jobExecution.getJobParameters().getParameters().forEach((name, value) -> result.getParameters().put((String)name, value.getValue().toString()));
        result.setRunning(jobExecution.isRunning());
        result.setStatus(jobExecution.getStatus().name());
        result.setCreateTime(BatchProcessDetail.doConvertToDate(jobExecution.getCreateTime()));
        result.setStartTime(BatchProcessDetail.doConvertToDate(jobExecution.getStartTime()));
        result.setEndTime(BatchProcessDetail.doConvertToDate(jobExecution.getEndTime()));
        result.setLastUpdateTime(BatchProcessDetail.doConvertToDate(jobExecution.getLastUpdated()));
        result.setExitStatus(jobExecution.getExitStatus().getExitCode());
        result.setErrors(jobExecution.getExitStatus().getExitDescription());
        return result;
    }

    private static Date doConvertToDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    @Generated
    public BatchProcessDetail() {
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @JsonProperty(value="jobName")
    @JsonView(value={View.GenericObjectView.class})
    @Generated
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Generated
    public long getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="jobId")
    @JsonView(value={View.GenericObjectView.class})
    @Generated
    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    @Generated
    public boolean isRunning() {
        return this.running;
    }

    @JsonProperty(value="running")
    @JsonView(value={View.GenericObjectView.class})
    @Generated
    public void setRunning(boolean running) {
        this.running = running;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonView(value={View.GenericObjectView.class})
    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    @JsonView(value={View.GenericObjectView.class})
    @Generated
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @JsonProperty(value="createTime")
    @JsonView(value={View.GenericObjectView.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @Generated
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    @JsonView(value={View.GenericObjectView.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public Date getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    @JsonView(value={View.GenericObjectView.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @Generated
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Generated
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @JsonProperty(value="lastUpdateTime")
    @JsonView(value={View.GenericObjectView.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @Generated
    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public String getExitStatus() {
        return this.exitStatus;
    }

    @JsonProperty(value="exitStatus")
    @JsonView(value={View.GenericObjectView.class})
    @Generated
    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    @Generated
    public String getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    @JsonView(value={View.GenericObjectView.class})
    @Generated
    public void setErrors(String errors) {
        this.errors = errors;
    }
}

