/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.collections;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="issues")
public class Issue {
    @JsonProperty(value="id")
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @JsonProperty(value="publisher")
    @Column(name="publisher", length=255, nullable=false, unique=false, updatable=false)
    @NonNull
    private String publisher;
    @JsonProperty(value="series")
    @Column(name="series", length=255, nullable=false, unique=false, updatable=false)
    @NonNull
    private String series;
    @JsonProperty(value="volume")
    @Column(name="volume", length=4, nullable=false, unique=false, updatable=false)
    @NonNull
    private String volume;
    @JsonProperty(value="issueNumber")
    @Column(name="issue_number", length=16, nullable=false, unique=false, updatable=false)
    @NonNull
    private String issueNumber;
    @JsonProperty(value="title")
    @Column(name="title", length=128, nullable=true, unique=false, updatable=false)
    private String title;
    @JsonProperty(value="coverDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @Column(name="cover_date", nullable=true, unique=false, updatable=false)
    private Date coverDate;
    @JsonProperty(value="storeDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @Column(name="store_date", nullable=true, unique=false, updatable=false)
    private Date storeDate;
    @JsonProperty(value="found")
    @Formula(value="(SELECT CASE WHEN COUNT(*) > 0 THEN true ELSE false END FROM comic_books c WHERE c.id IN (SELECT d.comic_book_id FROM comic_details d WHERE d.publisher = publisher AND d.series = series AND d.volume = volume AND d.issue_number = issue_number))")
    private boolean found;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return Objects.equals(this.publisher, issue.publisher) && Objects.equals(this.series, issue.series) && Objects.equals(this.volume, issue.volume) && Objects.equals(this.issueNumber, issue.issueNumber) && Objects.equals(this.title, issue.title) && Objects.equals(this.coverDate, issue.coverDate) && Objects.equals(this.storeDate, issue.storeDate);
    }

    public int hashCode() {
        return Objects.hash(this.publisher, this.series, this.volume, this.issueNumber, this.title, this.coverDate, this.storeDate);
    }

    @Generated
    public Issue() {
    }

    @Generated
    public Issue(@NonNull String publisher, @NonNull String series, @NonNull String volume, @NonNull String issueNumber) {
        if (publisher == null) {
            throw new NullPointerException("publisher is marked non-null but is null");
        }
        if (series == null) {
            throw new NullPointerException("series is marked non-null but is null");
        }
        if (volume == null) {
            throw new NullPointerException("volume is marked non-null but is null");
        }
        if (issueNumber == null) {
            throw new NullPointerException("issueNumber is marked non-null but is null");
        }
        this.publisher = publisher;
        this.series = series;
        this.volume = volume;
        this.issueNumber = issueNumber;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getPublisher() {
        return this.publisher;
    }

    @JsonProperty(value="publisher")
    @Generated
    public void setPublisher(@NonNull String publisher) {
        if (publisher == null) {
            throw new NullPointerException("publisher is marked non-null but is null");
        }
        this.publisher = publisher;
    }

    @NonNull
    @Generated
    public String getSeries() {
        return this.series;
    }

    @JsonProperty(value="series")
    @Generated
    public void setSeries(@NonNull String series) {
        if (series == null) {
            throw new NullPointerException("series is marked non-null but is null");
        }
        this.series = series;
    }

    @NonNull
    @Generated
    public String getVolume() {
        return this.volume;
    }

    @JsonProperty(value="volume")
    @Generated
    public void setVolume(@NonNull String volume) {
        if (volume == null) {
            throw new NullPointerException("volume is marked non-null but is null");
        }
        this.volume = volume;
    }

    @NonNull
    @Generated
    public String getIssueNumber() {
        return this.issueNumber;
    }

    @JsonProperty(value="issueNumber")
    @Generated
    public void setIssueNumber(@NonNull String issueNumber) {
        if (issueNumber == null) {
            throw new NullPointerException("issueNumber is marked non-null but is null");
        }
        this.issueNumber = issueNumber;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public Date getCoverDate() {
        return this.coverDate;
    }

    @JsonProperty(value="coverDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @Generated
    public void setCoverDate(Date coverDate) {
        this.coverDate = coverDate;
    }

    @Generated
    public Date getStoreDate() {
        return this.storeDate;
    }

    @JsonProperty(value="storeDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @Generated
    public void setStoreDate(Date storeDate) {
        this.storeDate = storeDate;
    }

    @Generated
    public boolean isFound() {
        return this.found;
    }

    @JsonProperty(value="found")
    @Generated
    public void setFound(boolean found) {
        this.found = found;
    }
}

