/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.comicbooks;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.comixedproject.model.comicbooks.ComicDetail;
import org.comixedproject.model.comicbooks.ComicMetadataSource;
import org.comixedproject.model.comicpages.ComicPage;
import org.comixedproject.model.comicpages.ComicPageState;
import org.comixedproject.views.View;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="comic_books")
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class ComicBook {
    @Generated
    private static final Logger log = LogManager.getLogger(ComicBook.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageList.class, View.ReadingListDetail.class})
    private Long id;
    @OneToOne(mappedBy="comicBook", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonProperty(value="detail")
    @JsonView(value={View.ComicListView.class, View.ComicDetailsView.class, View.ReadingListDetail.class})
    private ComicDetail comicDetail;
    @OneToOne(mappedBy="comicBook", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonProperty(value="metadata")
    @JsonView(value={View.ComicListView.class})
    private ComicMetadataSource metadata;
    @OneToMany(mappedBy="comicBook", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="page_number")
    @JsonProperty(value="pages")
    @JsonView(value={View.ComicListView.class, View.ReadingListDetail.class})
    List<ComicPage> pages = new ArrayList<ComicPage>();
    @Formula(value="(SELECT COUNT(*) FROM comic_pages p WHERE p.comic_book_id = id AND p.file_hash IN (SELECT d.file_hash FROM comic_pages d GROUP BY d.file_hash HAVING COUNT(*) > 1))")
    @JsonProperty(value="duplicatePageCount")
    @JsonView(value={View.ComicListView.class})
    private int duplicatePageCount;
    @Formula(value="(SELECT COUNT(*) FROM comic_pages p WHERE p.comic_book_id = id AND p.file_hash in (SELECT b.hash_value FROM blocked_hashes b))")
    @JsonProperty(value="blockedPageCount")
    @JsonView(value={View.ComicListView.class})
    private int blockedPageCount;
    @Transient
    @JsonProperty(value="nextIssueId")
    @JsonView(value={View.ComicDetailsView.class})
    private Long nextIssueId;
    @Transient
    @JsonProperty(value="previousIssueId")
    @JsonView(value={View.ComicDetailsView.class})
    private Long previousIssueId;
    @Column(name="file_contents_loaded", nullable=false, updatable=true)
    @JsonIgnore
    private boolean fileContentsLoaded = false;
    @Column(name="update_metadata", nullable=false, updatable=true)
    @JsonIgnore
    private boolean updateMetadata = false;
    @Column(name="batch_metadata_update", nullable=false, updatable=true)
    @JsonIgnore
    private boolean batchMetadataUpdate = false;
    @Column(name="organizing", nullable=false, updatable=true)
    @JsonIgnore
    private boolean organizing = false;
    @Column(name="recreating", nullable=false, updatable=true)
    @JsonIgnore
    private boolean recreating = false;
    @Column(name="edit_details", nullable=false, updatable=true)
    @JsonIgnore
    private boolean editDetails = false;
    @Column(name="purge_comic", nullable=false, updatable=true)
    @JsonIgnore
    private boolean purgeComic;
    @Column(name="last_modified_on", updatable=true, nullable=false)
    @JsonProperty(value="lastModifiedOn")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.ComicListView.class})
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModifiedOn = new Date();
    @Transient
    private String metadataSourceName;
    @Transient
    private String metadataReferenceId;

    @JsonProperty(value="missing")
    @JsonView(value={View.ComicListView.class})
    public boolean isMissing() {
        return !this.getComicDetail().getFile().exists();
    }

    public int getIndexFor(ComicPage page) {
        if (this.pages.contains(page)) {
            return this.pages.indexOf(page);
        }
        return -1;
    }

    @Transient
    @JsonProperty(value="pageCount")
    @JsonView(value={View.ComicListView.class})
    public int getPageCount() {
        if (!this.pages.isEmpty()) {
            return this.pages.size();
        }
        return 0;
    }

    public boolean hasPageWithFilename(String filename) {
        return this.getPageWithFilename(filename) != null;
    }

    public ComicPage getPageWithFilename(String filename) {
        if (this.pages.isEmpty()) {
            return null;
        }
        for (ComicPage page : this.pages) {
            if (!page.getFilename().equals(filename)) continue;
            return page;
        }
        return null;
    }

    public void sortPages() {
        this.pages.sort((p1, p2) -> p1.getFilename().compareTo(p2.getFilename()));
        this.updatePageNumbers();
    }

    public void updatePageNumbers() {
        for (int index = 0; index < this.pages.size(); ++index) {
            this.pages.get(index).setPageNumber(index);
        }
    }

    public void removeDeletedPages() {
        ArrayList<ComicPage> pages = new ArrayList<ComicPage>(this.pages);
        pages.forEach(page -> {
            if (page.getPageState() == ComicPageState.DELETED) {
                log.trace("Removing page: {}", (Object)page.getId());
                this.pages.remove(page);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComicBook comicBook = (ComicBook)o;
        return Objects.equals(this.comicDetail, comicBook.comicDetail);
    }

    public int hashCode() {
        return Objects.hash(this.comicDetail);
    }

    @Generated
    public ComicBook() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageList.class, View.ReadingListDetail.class})
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public ComicDetail getComicDetail() {
        return this.comicDetail;
    }

    @JsonProperty(value="detail")
    @JsonView(value={View.ComicListView.class, View.ComicDetailsView.class, View.ReadingListDetail.class})
    @Generated
    public void setComicDetail(ComicDetail comicDetail) {
        this.comicDetail = comicDetail;
    }

    @Generated
    public ComicMetadataSource getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setMetadata(ComicMetadataSource metadata) {
        this.metadata = metadata;
    }

    @Generated
    public List<ComicPage> getPages() {
        return this.pages;
    }

    @Generated
    public int getDuplicatePageCount() {
        return this.duplicatePageCount;
    }

    @Generated
    public int getBlockedPageCount() {
        return this.blockedPageCount;
    }

    @Generated
    public Long getNextIssueId() {
        return this.nextIssueId;
    }

    @JsonProperty(value="nextIssueId")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setNextIssueId(Long nextIssueId) {
        this.nextIssueId = nextIssueId;
    }

    @Generated
    public Long getPreviousIssueId() {
        return this.previousIssueId;
    }

    @JsonProperty(value="previousIssueId")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setPreviousIssueId(Long previousIssueId) {
        this.previousIssueId = previousIssueId;
    }

    @Generated
    public boolean isFileContentsLoaded() {
        return this.fileContentsLoaded;
    }

    @JsonIgnore
    @Generated
    public void setFileContentsLoaded(boolean fileContentsLoaded) {
        this.fileContentsLoaded = fileContentsLoaded;
    }

    @Generated
    public boolean isUpdateMetadata() {
        return this.updateMetadata;
    }

    @JsonIgnore
    @Generated
    public void setUpdateMetadata(boolean updateMetadata) {
        this.updateMetadata = updateMetadata;
    }

    @Generated
    public boolean isBatchMetadataUpdate() {
        return this.batchMetadataUpdate;
    }

    @JsonIgnore
    @Generated
    public void setBatchMetadataUpdate(boolean batchMetadataUpdate) {
        this.batchMetadataUpdate = batchMetadataUpdate;
    }

    @Generated
    public boolean isOrganizing() {
        return this.organizing;
    }

    @JsonIgnore
    @Generated
    public void setOrganizing(boolean organizing) {
        this.organizing = organizing;
    }

    @Generated
    public boolean isRecreating() {
        return this.recreating;
    }

    @JsonIgnore
    @Generated
    public void setRecreating(boolean recreating) {
        this.recreating = recreating;
    }

    @Generated
    public boolean isEditDetails() {
        return this.editDetails;
    }

    @JsonIgnore
    @Generated
    public void setEditDetails(boolean editDetails) {
        this.editDetails = editDetails;
    }

    @Generated
    public boolean isPurgeComic() {
        return this.purgeComic;
    }

    @JsonIgnore
    @Generated
    public void setPurgeComic(boolean purgeComic) {
        this.purgeComic = purgeComic;
    }

    @Generated
    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    @JsonProperty(value="lastModifiedOn")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    @Generated
    public String getMetadataSourceName() {
        return this.metadataSourceName;
    }

    @Generated
    public void setMetadataSourceName(String metadataSourceName) {
        this.metadataSourceName = metadataSourceName;
    }

    @Generated
    public String getMetadataReferenceId() {
        return this.metadataReferenceId;
    }

    @Generated
    public void setMetadataReferenceId(String metadataReferenceId) {
        this.metadataReferenceId = metadataReferenceId;
    }
}

