/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.comicbooks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.comicbooks.ComicDetail;
import org.comixedproject.model.comicbooks.ComicTagType;
import org.comixedproject.views.View;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="comic_tags")
public class ComicTag {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JoinColumn(name="comic_detail_id", insertable=true, nullable=false, updatable=false)
    @NonNull
    private ComicDetail comicDetail;
    @Column(name="tag_type", insertable=true, nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    @JsonProperty(value="type")
    @JsonView(value={View.ComicListView.class})
    @NonNull
    private ComicTagType type;
    @Column(name="tag_value", length=255, insertable=true, nullable=false, updatable=false)
    @JsonView(value={View.ComicListView.class})
    @JsonProperty(value="value")
    @NonNull
    private String value;
    @Formula(value="(SELECT COUNT(*) FROM comic_tags WHERE comic_tags.tag_type = tag_type AND comic_tags.tag_value = tag_value)")
    @JsonView(value={View.ComicListView.class})
    @JsonProperty(value="comicCount")
    private Integer comicCount;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComicTag comicTag = (ComicTag)o;
        return this.type == comicTag.type && this.value.equals(comicTag.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    @Generated
    public ComicTag() {
    }

    @Generated
    public ComicTag(@NonNull ComicDetail comicDetail, @NonNull ComicTagType type, @NonNull String value) {
        if (comicDetail == null) {
            throw new NullPointerException("comicDetail is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.comicDetail = comicDetail;
        this.type = type;
        this.value = value;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public ComicDetail getComicDetail() {
        return this.comicDetail;
    }

    @NonNull
    @Generated
    public ComicTagType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Integer getComicCount() {
        return this.comicCount;
    }
}

