/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.comicpages;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.views.View;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="blocked_hashes")
public class BlockedHash {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.BlockedHashList.class})
    private Long id;
    @Column(name="label", nullable=true, updatable=true, length=128)
    @JsonProperty(value="label")
    @JsonView(value={View.BlockedHashList.class})
    @NonNull
    private String label;
    @Column(name="hash_value", nullable=false, unique=true, updatable=false, length=32)
    @JsonProperty(value="hash")
    @JsonView(value={View.BlockedHashList.class})
    @NonNull
    private String hash;
    @Column(name="thumbnail", nullable=true, updatable=false)
    @Lob
    @JsonProperty(value="thumbnail")
    @NonNull
    private String thumbnail;
    @Column(name="created_on", nullable=false, updatable=false)
    @JsonProperty(value="createdOn")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.BlockedHashList.class})
    private Date createdOn = new Date();
    @Formula(value="(SELECT COUNT(*) FROM comic_books c WHERE c.id IN (SELECT p.comic_book_id FROM comic_pages p WHERE p.file_hash = hash_value))")
    @JsonProperty(value="comicCount")
    @JsonView(value={View.BlockedHashList.class})
    private Integer comicCount;

    public int hashCode() {
        return Objects.hash(this.label, this.hash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockedHash that = (BlockedHash)o;
        return Objects.equals(this.label, that.label) && Objects.equals(this.hash, that.hash);
    }

    @Generated
    public BlockedHash() {
    }

    @Generated
    public BlockedHash(@NonNull String label, @NonNull String hash, @NonNull String thumbnail) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        if (thumbnail == null) {
            throw new NullPointerException("thumbnail is marked non-null but is null");
        }
        this.label = label;
        this.hash = hash;
        this.thumbnail = thumbnail;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonView(value={View.BlockedHashList.class})
    @Generated
    public void setLabel(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
    }

    @NonNull
    @Generated
    public String getHash() {
        return this.hash;
    }

    @NonNull
    @Generated
    public String getThumbnail() {
        return this.thumbnail;
    }

    @Generated
    public Date getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public Integer getComicCount() {
        return this.comicCount;
    }
}

