/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.comicpages;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.comixedproject.model.comicbooks.ComicBook;
import org.comixedproject.model.comicpages.ComicPageState;
import org.comixedproject.views.View;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="comic_pages")
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class ComicPage {
    @Generated
    private static final Logger log = LogManager.getLogger(ComicPage.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.ComicDetailsView.class})
    private Long id;
    @ManyToOne
    @JoinColumn(name="comic_book_id")
    @JsonProperty(value="comicBook")
    @NonNull
    private ComicBook comicBook;
    @Column(name="page_state", nullable=false, updatable=true)
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private ComicPageState pageState = ComicPageState.STABLE;
    @Column(name="filename", length=1024, updatable=true, nullable=false)
    @JsonProperty(value="filename")
    @JsonView(value={View.ComicListView.class})
    @NonNull
    private String filename;
    @Column(name="file_hash", length=32, updatable=true, nullable=true)
    @JsonProperty(value="hash")
    @JsonView(value={View.ComicListView.class})
    private String hash;
    @Column(name="page_number", nullable=false, updatable=true)
    @JsonProperty(value="pageNumber")
    @JsonView(value={View.ComicDetailsView.class})
    @NonNull
    private Integer pageNumber;
    @Column(name="width", nullable=false, updatable=true)
    @JsonProperty(value="width")
    @JsonView(value={View.ComicDetailsView.class})
    private Integer width = -1;
    @Column(name="height", nullable=false, updatable=true)
    @JsonProperty(value="height")
    @JsonView(value={View.ComicDetailsView.class})
    private Integer height = -1;
    @Column(name="adding_to_cache", updatable=true)
    @JsonIgnore
    private Boolean addingToCache = false;
    @Formula(value="(SELECT CASE WHEN (file_hash IN (SELECT b.hash_value FROM blocked_hashes b)) THEN true ELSE false END)")
    @JsonProperty(value="blocked")
    @JsonView(value={View.ComicListView.class})
    private boolean blocked;

    @Transient
    @JsonProperty(value="index")
    @JsonView(value={View.ComicDetailsView.class})
    public int getIndex() {
        return this.comicBook.getIndexFor(this);
    }

    @Transient
    @JsonProperty(value="deleted")
    @JsonView(value={View.ComicListView.class})
    public boolean isDeleted() {
        return ComicPageState.DELETED.equals((Object)this.pageState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComicPage page = (ComicPage)o;
        return this.isBlocked() == page.isBlocked() && Objects.equals(this.getComicBook(), page.getComicBook()) && this.getPageState() == page.getPageState() && Objects.equals(this.getFilename(), page.getFilename()) && Objects.equals(this.getHash(), page.getHash()) && Objects.equals(this.getPageNumber(), page.getPageNumber()) && Objects.equals(this.getWidth(), page.getWidth()) && Objects.equals(this.getHeight(), page.getHeight()) && Objects.equals(this.getAddingToCache(), page.getAddingToCache());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getId(), this.getComicBook(), this.getPageState(), this.getFilename(), this.getHash(), this.getPageNumber(), this.getWidth(), this.getHeight(), this.getAddingToCache(), this.isBlocked()});
    }

    @Generated
    public ComicPage() {
    }

    @Generated
    public ComicPage(@NonNull ComicBook comicBook, @NonNull String filename, @NonNull Integer pageNumber) {
        if (comicBook == null) {
            throw new NullPointerException("comicBook is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        if (pageNumber == null) {
            throw new NullPointerException("pageNumber is marked non-null but is null");
        }
        this.comicBook = comicBook;
        this.filename = filename;
        this.pageNumber = pageNumber;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public ComicBook getComicBook() {
        return this.comicBook;
    }

    @JsonProperty(value="comicBook")
    @Generated
    public void setComicBook(@NonNull ComicBook comicBook) {
        if (comicBook == null) {
            throw new NullPointerException("comicBook is marked non-null but is null");
        }
        this.comicBook = comicBook;
    }

    @NonNull
    @Generated
    public ComicPageState getPageState() {
        return this.pageState;
    }

    @Generated
    public void setPageState(@NonNull ComicPageState pageState) {
        if (pageState == null) {
            throw new NullPointerException("pageState is marked non-null but is null");
        }
        this.pageState = pageState;
    }

    @NonNull
    @Generated
    public String getFilename() {
        return this.filename;
    }

    @JsonProperty(value="filename")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setFilename(@NonNull String filename) {
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.filename = filename;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @JsonProperty(value="hash")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @NonNull
    @Generated
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    @JsonProperty(value="pageNumber")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setPageNumber(@NonNull Integer pageNumber) {
        if (pageNumber == null) {
            throw new NullPointerException("pageNumber is marked non-null but is null");
        }
        this.pageNumber = pageNumber;
    }

    @Generated
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setWidth(Integer width) {
        this.width = width;
    }

    @Generated
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setHeight(Integer height) {
        this.height = height;
    }

    @Generated
    public Boolean getAddingToCache() {
        return this.addingToCache;
    }

    @JsonIgnore
    @Generated
    public void setAddingToCache(Boolean addingToCache) {
        this.addingToCache = addingToCache;
    }

    @Generated
    public boolean isBlocked() {
        return this.blocked;
    }
}

