/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.lists;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.comixedproject.model.comicbooks.ComicDetail;
import org.comixedproject.model.lists.ReadingListState;
import org.comixedproject.model.user.ComiXedUser;
import org.comixedproject.views.View;
import org.hibernate.annotations.ColumnTransformer;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

@Entity
@Table(name="reading_lists")
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class ReadingList {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.ComicListView.class, View.ReadingLists.class})
    private Long id;
    @Column(name="reading_list_state", nullable=false, updatable=true)
    @Enumerated(value=EnumType.STRING)
    @JsonProperty(value="readingListState")
    @JsonView(value={View.ComicListView.class, View.ReadingLists.class})
    private ReadingListState readingListState = ReadingListState.STABLE;
    @Column(name="name_key", length=128)
    @ColumnTransformer(write="(UPPER(?))")
    @JsonIgnore
    private String nameKey;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="owner_id")
    @JsonProperty(value="owner")
    @JsonView(value={View.ComicListView.class, View.ReadingLists.class})
    private ComiXedUser owner;
    @Column(name="reading_list_name", length=128)
    @JsonProperty(value="name")
    @JsonView(value={View.ComicListView.class, View.ReadingLists.class})
    private String name;
    @Column(name="summary", length=256, nullable=true)
    @JsonProperty(value="summary")
    @JsonView(value={View.ComicListView.class, View.ReadingLists.class})
    private String summary;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="reading_list_entries", joinColumns={@JoinColumn(name="reading_list_id")}, inverseJoinColumns={@JoinColumn(name="comic_detail_id")})
    @JsonProperty(value="entries")
    @JsonView(value={View.ReadingLists.class})
    private List<ComicDetail> entries = new ArrayList<ComicDetail>();
    @Column(name="created_on")
    @CreatedDate
    @JsonProperty(value="createdOn")
    @JsonView(value={View.ComicListView.class, View.ReadingLists.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    private Date createdOn = new Date();
    @Column(name="last_modified_on")
    @LastModifiedDate
    @JsonProperty(value="lastModifiedOn")
    @JsonView(value={View.ComicListView.class, View.ReadingListDetail.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    private Date lastModifiedOn = new Date();

    public void setName(String name) {
        this.name = name;
        this.nameKey = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadingList that = (ReadingList)o;
        return Objects.equals(this.id, that.id) && Objects.equals((Object)this.readingListState, (Object)that.readingListState) && Objects.equals(this.nameKey, that.nameKey) && Objects.equals(this.name, that.name) && Objects.equals(this.summary, that.summary) && Objects.equals(this.owner, that.owner) && Objects.equals(this.createdOn, that.createdOn) && Objects.equals(this.lastModifiedOn, that.lastModifiedOn);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.readingListState, this.name, this.summary, this.owner, this.createdOn, this.lastModifiedOn});
    }

    @Generated
    public ReadingList() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public ReadingListState getReadingListState() {
        return this.readingListState;
    }

    @JsonProperty(value="readingListState")
    @JsonView(value={View.ComicListView.class, View.ReadingLists.class})
    @Generated
    public void setReadingListState(ReadingListState readingListState) {
        this.readingListState = readingListState;
    }

    @Generated
    public String getNameKey() {
        return this.nameKey;
    }

    @Generated
    public ComiXedUser getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonView(value={View.ComicListView.class, View.ReadingLists.class})
    @Generated
    public void setOwner(ComiXedUser owner) {
        this.owner = owner;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    @JsonView(value={View.ComicListView.class, View.ReadingLists.class})
    @Generated
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Generated
    public List<ComicDetail> getEntries() {
        return this.entries;
    }

    @Generated
    public Date getCreatedOn() {
        return this.createdOn;
    }

    @JsonProperty(value="createdOn")
    @JsonView(value={View.ComicListView.class, View.ReadingLists.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @Generated
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    @JsonProperty(value="lastModifiedOn")
    @JsonView(value={View.ComicListView.class, View.ReadingListDetail.class})
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @Generated
    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }
}

