/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.lists;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.comicbooks.ComicBook;
import org.comixedproject.model.lists.Story;
import org.comixedproject.model.lists.StoryEntryState;
import org.comixedproject.views.View;

@Entity
@Table(name="story_entries")
public class StoryEntry {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.StoryList.class})
    private Long id;
    @ManyToOne
    @JoinColumn(name="story_id", nullable=false, updatable=false)
    @NonNull
    private Story story;
    @Column(name="story_entry_state", nullable=false, updatable=true)
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private StoryEntryState storyEntryState = StoryEntryState.DEFINED;
    @Column(name="reading_order", nullable=false, updatable=false)
    @JsonProperty(value="readingOrder")
    @JsonView(value={View.StoryList.class})
    private int readingOrder;
    @Column(name="series", length=128, nullable=false, updatable=true)
    @JsonProperty(value="series")
    @JsonView(value={View.StoryList.class})
    private String series;
    @Column(name="volume", length=4, nullable=false, updatable=true)
    @JsonProperty(value="volume")
    @JsonView(value={View.StoryList.class})
    private String volume;
    @Column(name="issue_number", length=16, nullable=false, updatable=false)
    @JsonProperty(value="issueNumber")
    @JsonView(value={View.StoryList.class})
    private String issueNumber;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="comic_book_id", nullable=true, updatable=false)
    @JsonView(value={View.StoryList.class})
    @JsonProperty(value="comicBook")
    private ComicBook comicBook;
    @Column(name="comic_vine_id", nullable=true, updatable=true, unique=true)
    @JsonProperty(value="comicVineId")
    @JsonView(value={View.StoryList.class})
    private Integer comicVineId;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoryEntry that = (StoryEntry)o;
        return this.readingOrder == that.readingOrder && this.story.equals(that.story) && this.storyEntryState.equals((Object)that.storyEntryState) && this.series.equals(that.series) && this.volume.equals(that.volume) && this.issueNumber.equals(that.issueNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.story, this.storyEntryState, this.readingOrder, this.series, this.volume, this.issueNumber});
    }

    @Generated
    public StoryEntry() {
    }

    @Generated
    public StoryEntry(@NonNull Story story) {
        if (story == null) {
            throw new NullPointerException("story is marked non-null but is null");
        }
        this.story = story;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public Story getStory() {
        return this.story;
    }

    @NonNull
    @Generated
    public StoryEntryState getStoryEntryState() {
        return this.storyEntryState;
    }

    @Generated
    public void setStoryEntryState(@NonNull StoryEntryState storyEntryState) {
        if (storyEntryState == null) {
            throw new NullPointerException("storyEntryState is marked non-null but is null");
        }
        this.storyEntryState = storyEntryState;
    }

    @Generated
    public int getReadingOrder() {
        return this.readingOrder;
    }

    @Generated
    public String getSeries() {
        return this.series;
    }

    @JsonProperty(value="series")
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setSeries(String series) {
        this.series = series;
    }

    @Generated
    public String getVolume() {
        return this.volume;
    }

    @JsonProperty(value="volume")
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setVolume(String volume) {
        this.volume = volume;
    }

    @Generated
    public String getIssueNumber() {
        return this.issueNumber;
    }

    @JsonProperty(value="issueNumber")
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setIssueNumber(String issueNumber) {
        this.issueNumber = issueNumber;
    }

    @Generated
    public ComicBook getComicBook() {
        return this.comicBook;
    }

    @JsonView(value={View.StoryList.class})
    @JsonProperty(value="comicBook")
    @Generated
    public void setComicBook(ComicBook comicBook) {
        this.comicBook = comicBook;
    }

    @Generated
    public Integer getComicVineId() {
        return this.comicVineId;
    }

    @JsonProperty(value="comicVineId")
    @JsonView(value={View.StoryList.class})
    @Generated
    public void setComicVineId(Integer comicVineId) {
        this.comicVineId = comicVineId;
    }
}

