/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.metadata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.views.View;

@Entity
@Table(name="filename_scraping_rules")
public class FilenameScrapingRule {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    private Long id;
    @Column(name="rule_name", length=25, nullable=false, unique=true)
    @JsonProperty(value="name")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @NonNull
    private String name;
    @Column(name="rule", length=256, nullable=false, unique=true)
    @JsonProperty(value="rule")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @NonNull
    private String rule;
    @Column(name="priority", nullable=false, updatable=true, unique=true)
    @JsonProperty(value="priority")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @NonNull
    private Integer priority;
    @Column(name="series_position", nullable=true)
    @JsonProperty(value="seriesPosition")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    private Integer seriesPosition = 1;
    @Column(name="volume_position", nullable=true)
    @JsonProperty(value="volumePosition")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    private Integer volumePosition = 1;
    @Column(name="issue_number_position", nullable=true)
    @JsonProperty(value="issueNumberPosition")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    private Integer issueNumberPosition = 1;
    @Column(name="cover_date_position", nullable=true)
    @JsonProperty(value="coverDatePosition")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    private Integer coverDatePosition = 1;
    @Column(name="date_format", nullable=true, length=32)
    @JsonProperty(value="dateFormat")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    private String dateFormat = "";
    @Column(name="last_modified_on", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonProperty(value="lastModifiedOn")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.FilenameScrapingRuleList.class})
    private Date lastModifiedOn = new Date();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilenameScrapingRule that = (FilenameScrapingRule)o;
        return this.priority == that.priority && Objects.equals(this.name, that.name) && Objects.equals(this.rule, that.rule) && Objects.equals(this.seriesPosition, that.seriesPosition) && Objects.equals(this.volumePosition, that.volumePosition) && Objects.equals(this.issueNumberPosition, that.issueNumberPosition) && Objects.equals(this.coverDatePosition, that.coverDatePosition) && Objects.equals(this.dateFormat, that.dateFormat);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rule, this.priority, this.seriesPosition, this.volumePosition, this.issueNumberPosition, this.coverDatePosition, this.dateFormat);
    }

    @Generated
    public FilenameScrapingRule() {
    }

    @Generated
    public FilenameScrapingRule(@NonNull String name, @NonNull String rule, @NonNull Integer priority) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (rule == null) {
            throw new NullPointerException("rule is marked non-null but is null");
        }
        if (priority == null) {
            throw new NullPointerException("priority is marked non-null but is null");
        }
        this.name = name;
        this.rule = rule;
        this.priority = priority;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @Generated
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @NonNull
    @Generated
    public String getRule() {
        return this.rule;
    }

    @JsonProperty(value="rule")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @Generated
    public void setRule(@NonNull String rule) {
        if (rule == null) {
            throw new NullPointerException("rule is marked non-null but is null");
        }
        this.rule = rule;
    }

    @NonNull
    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @Generated
    public void setPriority(@NonNull Integer priority) {
        if (priority == null) {
            throw new NullPointerException("priority is marked non-null but is null");
        }
        this.priority = priority;
    }

    @Generated
    public Integer getSeriesPosition() {
        return this.seriesPosition;
    }

    @JsonProperty(value="seriesPosition")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @Generated
    public void setSeriesPosition(Integer seriesPosition) {
        this.seriesPosition = seriesPosition;
    }

    @Generated
    public Integer getVolumePosition() {
        return this.volumePosition;
    }

    @JsonProperty(value="volumePosition")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @Generated
    public void setVolumePosition(Integer volumePosition) {
        this.volumePosition = volumePosition;
    }

    @Generated
    public Integer getIssueNumberPosition() {
        return this.issueNumberPosition;
    }

    @JsonProperty(value="issueNumberPosition")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @Generated
    public void setIssueNumberPosition(Integer issueNumberPosition) {
        this.issueNumberPosition = issueNumberPosition;
    }

    @Generated
    public Integer getCoverDatePosition() {
        return this.coverDatePosition;
    }

    @JsonProperty(value="coverDatePosition")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @Generated
    public void setCoverDatePosition(Integer coverDatePosition) {
        this.coverDatePosition = coverDatePosition;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @JsonProperty(value="dateFormat")
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @Generated
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Generated
    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    @JsonProperty(value="lastModifiedOn")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.FilenameScrapingRuleList.class})
    @Generated
    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }
}

