/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.metadata;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.comixedproject.model.metadata.MetadataCacheEntry;

@Entity
@Table(name="metadata_cache")
public class MetadataCache {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="metadata_source", length=32, updatable=false, nullable=false)
    private String source;
    @Column(name="cache_key", length=256, updatable=false, nullable=false)
    private String cacheKey;
    @Column(name="created_on", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn = new Date();
    @OneToMany(mappedBy="metadataCache", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="entry_number")
    private List<MetadataCacheEntry> entries = new ArrayList<MetadataCacheEntry>();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Generated
    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    @Generated
    public Date getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public List<MetadataCacheEntry> getEntries() {
        return this.entries;
    }
}

