/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.metadata.MetadataSourceProperty;
import org.comixedproject.views.View;

@Entity
@Table(name="metadata_sources")
public class MetadataSource {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.MetadataSourceList.class, View.ComicDetailsView.class})
    private Long id;
    @Column(name="adaptor_name", length=64, unique=true, insertable=true, updatable=true, nullable=false)
    @JsonProperty(value="name")
    @JsonView(value={View.MetadataSourceList.class, View.ComicDetailsView.class})
    @NonNull
    private String adaptorName;
    @Column(name="preferred_source", insertable=true, updatable=true, nullable=false)
    @JsonProperty(value="preferred")
    @JsonView(value={View.MetadataSourceList.class, View.ComicDetailsView.class})
    @NonNull
    private Boolean preferred = false;
    @OneToMany(mappedBy="source", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @JsonProperty(value="properties")
    @JsonView(value={View.MetadataSourceList.class})
    private Set<MetadataSourceProperty> properties = new HashSet<MetadataSourceProperty>();
    @Transient
    @JsonProperty(value="available")
    @JsonView(value={View.MetadataSourceList.class})
    private boolean available = false;
    @Transient
    @JsonProperty(value="version")
    @JsonView(value={View.MetadataSourceList.class})
    private String version;
    @Transient
    @JsonProperty(value="homepage")
    @JsonView(value={View.MetadataSourceList.class})
    private String homepage;

    public int hashCode() {
        return Objects.hash(this.adaptorName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataSource that = (MetadataSource)o;
        return this.adaptorName.equals(that.adaptorName);
    }

    @Generated
    public MetadataSource() {
    }

    @Generated
    public MetadataSource(@NonNull String adaptorName) {
        if (adaptorName == null) {
            throw new NullPointerException("adaptorName is marked non-null but is null");
        }
        this.adaptorName = adaptorName;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getAdaptorName() {
        return this.adaptorName;
    }

    @JsonProperty(value="name")
    @JsonView(value={View.MetadataSourceList.class, View.ComicDetailsView.class})
    @Generated
    public void setAdaptorName(@NonNull String adaptorName) {
        if (adaptorName == null) {
            throw new NullPointerException("adaptorName is marked non-null but is null");
        }
        this.adaptorName = adaptorName;
    }

    @NonNull
    @Generated
    public Boolean getPreferred() {
        return this.preferred;
    }

    @JsonProperty(value="preferred")
    @JsonView(value={View.MetadataSourceList.class, View.ComicDetailsView.class})
    @Generated
    public void setPreferred(@NonNull Boolean preferred) {
        if (preferred == null) {
            throw new NullPointerException("preferred is marked non-null but is null");
        }
        this.preferred = preferred;
    }

    @Generated
    public Set<MetadataSourceProperty> getProperties() {
        return this.properties;
    }

    @Generated
    public boolean isAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonView(value={View.MetadataSourceList.class})
    @Generated
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonView(value={View.MetadataSourceList.class})
    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public String getHomepage() {
        return this.homepage;
    }

    @JsonProperty(value="homepage")
    @JsonView(value={View.MetadataSourceList.class})
    @Generated
    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }
}

