/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.metadata.MetadataSource;
import org.comixedproject.views.View;

@Entity
@Table(name="metadata_source_properties")
public class MetadataSourceProperty {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JoinColumn(name="metadata_source_id", nullable=false, updatable=false)
    @NonNull
    private MetadataSource source;
    @Column(name="property_name", length=32, insertable=true, updatable=false, nullable=false)
    @JsonProperty(value="name")
    @JsonView(value={View.MetadataSourceList.class})
    @NonNull
    private String name;
    @Column(name="property_value", length=255, insertable=true, updatable=true, nullable=true)
    @JsonProperty(value="value")
    @JsonView(value={View.MetadataSourceList.class})
    @NonNull
    private String value;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataSourceProperty that = (MetadataSourceProperty)o;
        return this.name.equals(that.name) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Generated
    public MetadataSourceProperty() {
    }

    @Generated
    public MetadataSourceProperty(@NonNull MetadataSource source, @NonNull String name, @NonNull String value) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.source = source;
        this.name = name;
        this.value = value;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public MetadataSource getSource() {
        return this.source;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonView(value={View.MetadataSourceList.class})
    @Generated
    public void setValue(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }
}

