/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.plugin;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.plugin.LibraryPluginProperty;
import org.comixedproject.views.View;
import org.hibernate.annotations.ColumnTransformer;

@Entity
@Table(name="library_plugins")
public class LibraryPlugin {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonProperty(value="id")
    @JsonView(value={View.LibraryPluginList.class})
    private Long id;
    @Column(name="name", length=64, insertable=true, updatable=false, nullable=false)
    @JsonProperty(value="name")
    @JsonView(value={View.LibraryPluginList.class})
    @NonNull
    private String name;
    @Column(name="unique_name", length=64, insertable=true, updatable=false, nullable=false, unique=true)
    @ColumnTransformer(write="(UPPER(?))")
    @NonNull
    private String uniqueName;
    @Column(name="language", length=32, updatable=false, nullable=false)
    @JsonProperty(value="language")
    @JsonView(value={View.LibraryPluginList.class})
    @NonNull
    private String language;
    @Column(name="version", length=16, updatable=true, nullable=false)
    @JsonProperty(value="version")
    @JsonView(value={View.LibraryPluginList.class})
    @NonNull
    private String version;
    @Column(name="filename", length=1024, nullable=false, updatable=true)
    @JsonProperty(value="filename")
    @JsonView(value={View.LibraryPluginList.class})
    @NonNull
    private String filename;
    @Column(name="admin_only", nullable=false)
    @JsonProperty(value="adminOnly")
    @JsonView(value={View.LibraryPluginList.class})
    private Boolean adminOnly = true;
    @OneToMany(mappedBy="plugin", orphanRemoval=true, cascade={CascadeType.ALL})
    @JsonProperty(value="properties")
    @JsonView(value={View.LibraryPluginList.class})
    private List<LibraryPluginProperty> properties = new ArrayList<LibraryPluginProperty>();

    public String toString() {
        return "LibraryPlugin{name='" + this.name + "', uniqueName='" + this.uniqueName + "', language='" + this.language + "', version='" + this.version + "', filename='" + this.filename + "', adminOnly=" + this.adminOnly + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryPlugin libraryPlugin = (LibraryPlugin)o;
        return Objects.equals(this.name, libraryPlugin.name) && Objects.equals(this.uniqueName, libraryPlugin.uniqueName) && Objects.equals(this.language, libraryPlugin.language) && Objects.equals(this.version, libraryPlugin.version) && Objects.equals(this.filename, libraryPlugin.filename) && Objects.equals(this.adminOnly, libraryPlugin.adminOnly);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uniqueName, this.language, this.version, this.filename, this.adminOnly);
    }

    @Generated
    public LibraryPlugin() {
    }

    @Generated
    public LibraryPlugin(@NonNull String name, @NonNull String uniqueName, @NonNull String language, @NonNull String version, @NonNull String filename) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (uniqueName == null) {
            throw new NullPointerException("uniqueName is marked non-null but is null");
        }
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.name = name;
        this.uniqueName = uniqueName;
        this.language = language;
        this.version = version;
        this.filename = filename;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public String getUniqueName() {
        return this.uniqueName;
    }

    @NonNull
    @Generated
    public String getLanguage() {
        return this.language;
    }

    @NonNull
    @Generated
    public String getVersion() {
        return this.version;
    }

    @NonNull
    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public Boolean getAdminOnly() {
        return this.adminOnly;
    }

    @JsonProperty(value="adminOnly")
    @JsonView(value={View.LibraryPluginList.class})
    @Generated
    public void setAdminOnly(Boolean adminOnly) {
        this.adminOnly = adminOnly;
    }

    @Generated
    public List<LibraryPluginProperty> getProperties() {
        return this.properties;
    }
}

