/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.plugin;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.plugin.LibraryPlugin;
import org.comixedproject.views.View;

@Entity
@Table(name="library_plugin_properties")
public class LibraryPluginProperty {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JoinColumn(name="library_plugin_id", insertable=true, updatable=false, nullable=false)
    private LibraryPlugin plugin;
    @Column(name="property_name", length=32, insertable=true, updatable=true, nullable=false)
    @JsonProperty(value="name")
    @JsonView(value={View.LibraryPluginList.class})
    @NonNull
    private String name;
    @Column(name="property_length", insertable=true, updatable=true, nullable=false)
    @JsonProperty(value="length")
    @JsonView(value={View.LibraryPluginList.class})
    @NonNull
    private Integer length;
    @Column(name="property_required", insertable=true, updatable=true, nullable=false)
    @JsonProperty(value="required")
    @JsonView(value={View.LibraryPluginList.class})
    private Boolean required = false;
    @Column(name="property_default_value", length=128, insertable=true, updatable=false)
    @JsonProperty(value="defaultValue")
    @JsonView(value={View.LibraryPluginList.class})
    private String defaultValue = "";
    @Column(name="property_value", length=128, insertable=true, updatable=true, nullable=false)
    @JsonProperty(value="value")
    @JsonView(value={View.LibraryPluginList.class})
    private String value = "";

    public static LibraryPluginProperty createProperty(String name, int length, String defaultValue) {
        return new LibraryPluginProperty(name, length);
    }

    public static LibraryPluginProperty createRequiredProperty(String name, int length, String defaultValue) {
        LibraryPluginProperty result = new LibraryPluginProperty(name, length);
        result.setRequired(true);
        return result;
    }

    public String toString() {
        return "LibraryPluginProperty{plugin=" + this.plugin + ", name='" + this.name + "', length=" + this.length + ", value='" + this.value + "', required=" + this.required + ", defaultValue='" + this.defaultValue + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryPluginProperty that = (LibraryPluginProperty)o;
        return Objects.equals(this.plugin, that.plugin) && Objects.equals(this.name, that.name) && Objects.equals(this.length, that.length) && Objects.equals(this.value, that.value) && Objects.equals(this.required, that.required) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.plugin, this.name, this.length, this.value, this.required, this.defaultValue);
    }

    @Generated
    public LibraryPluginProperty() {
    }

    @Generated
    public LibraryPluginProperty(@NonNull String name, @NonNull Integer length) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        this.name = name;
        this.length = length;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LibraryPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public void setPlugin(LibraryPlugin plugin) {
        this.plugin = plugin;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonView(value={View.LibraryPluginList.class})
    @Generated
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @NonNull
    @Generated
    public Integer getLength() {
        return this.length;
    }

    @JsonProperty(value="length")
    @JsonView(value={View.LibraryPluginList.class})
    @Generated
    public void setLength(@NonNull Integer length) {
        if (length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        this.length = length;
    }

    @Generated
    public Boolean getRequired() {
        return this.required;
    }

    @JsonProperty(value="required")
    @JsonView(value={View.LibraryPluginList.class})
    @Generated
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @JsonProperty(value="defaultValue")
    @JsonView(value={View.LibraryPluginList.class})
    @Generated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonView(value={View.LibraryPluginList.class})
    @Generated
    public void setValue(String value) {
        this.value = value;
    }
}

