/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.comixedproject.model.user.ComiXedRole;
import org.comixedproject.model.user.ComiXedUserPreference;
import org.comixedproject.views.View;

@Entity
@Table(name="comixed_users")
public class ComiXedUser {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonView(value={View.UserList.class})
    private Long id;
    @Column(name="email", updatable=true, nullable=false, unique=true)
    @JsonView(value={View.UserList.class})
    private String email;
    @Transient
    @JsonIgnore
    private String password;
    @Column(name="password_hash", updatable=true, nullable=false)
    private String passwordHash;
    @Column(name="created_on", nullable=false, updatable=false)
    @JsonProperty(value="first_login_date")
    @JsonView(value={View.UserList.class})
    private Date firstLoginDate = new Date();
    @Column(name="last_logged_on", nullable=false, updatable=true)
    @JsonProperty(value="last_login_date")
    @JsonView(value={View.UserList.class})
    private Date lastLoginDate = new Date();
    @ManyToMany
    @JoinTable(name="comixed_user_roles", joinColumns={@JoinColumn(name="comixed_user_id")}, inverseJoinColumns={@JoinColumn(name="comixed_role_id")})
    @JsonView(value={View.UserList.class})
    private List<ComiXedRole> roles = new ArrayList<ComiXedRole>();
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @JsonView(value={View.UserList.class})
    private List<ComiXedUserPreference> preferences = new ArrayList<ComiXedUserPreference>();
    @Transient
    @JsonView(value={View.UserList.class})
    private boolean authenticated = false;

    public void addRole(ComiXedRole role) {
        if (!this.roles.contains(role)) {
            this.roles.add(role);
        }
    }

    public void setProperty(String name, String value) {
        for (ComiXedUserPreference preference : this.preferences) {
            if (!preference.getName().equals(name)) continue;
            preference.setValue(value);
            return;
        }
        ComiXedUserPreference preference = new ComiXedUserPreference(name);
        preference.setUser(this);
        preference.setValue(value);
        this.preferences.add(preference);
    }

    public void deleteProperty(String name) {
        ComiXedUserPreference preference = null;
        int index = -1;
        for (int which = 0; which < this.preferences.size(); ++which) {
            if (!this.preferences.get(which).getName().equals(name)) continue;
            preference = this.preferences.get(which);
            index = which;
            break;
        }
        if (preference != null) {
            preference.setUser(null);
            this.preferences.remove(index);
        }
    }

    public void clearRoles() {
        this.roles.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComiXedUser that = (ComiXedUser)o;
        return Objects.equals(this.email, that.email);
    }

    public int hashCode() {
        return Objects.hash(this.email);
    }

    @Transient
    public boolean isAdmin() {
        return this.roles.stream().anyMatch(roles -> roles.getName().equals("ADMIN"));
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @JsonView(value={View.UserList.class})
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public String getPasswordHash() {
        return this.passwordHash;
    }

    @Generated
    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    @Generated
    public Date getFirstLoginDate() {
        return this.firstLoginDate;
    }

    @Generated
    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    @JsonProperty(value="last_login_date")
    @JsonView(value={View.UserList.class})
    @Generated
    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    @Generated
    public List<ComiXedRole> getRoles() {
        return this.roles;
    }

    @Generated
    public List<ComiXedUserPreference> getPreferences() {
        return this.preferences;
    }

    @Generated
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @JsonView(value={View.UserList.class})
    @Generated
    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }
}

