/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.change;

import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.commonjava.couch.change.CouchDocChange;
import org.commonjava.couch.change.CouchDocChangeDeserializer;
import org.commonjava.couch.change.CouchDocChangeList;
import org.commonjava.couch.change.dispatch.CouchChangeDispatcher;
import org.commonjava.couch.conf.CouchDBConfiguration;
import org.commonjava.couch.db.CouchDBException;
import org.commonjava.couch.db.CouchManager;
import org.commonjava.couch.io.CouchHttpClient;
import org.commonjava.couch.io.Serializer;
import org.commonjava.couch.model.AbstractCouchDocument;
import org.commonjava.couch.model.CouchDocRef;
import org.commonjava.couch.util.UrlUtils;
import org.commonjava.util.logging.Logger;

@Singleton
public class CouchChangeListener
implements Runnable {
    private static final String CHANGE_LISTENER_DOCID = "change-listener-metadata";
    private static final String CHANGES_SERVICE = "_changes";
    private final Logger logger = new Logger(this.getClass());
    @Inject
    private CouchChangeDispatcher dispatcher;
    @Inject
    private CouchDBConfiguration config;
    @Inject
    private CouchHttpClient http;
    @Inject
    private CouchManager couch;
    @Inject
    private Serializer serializer;
    private ChangeListenerMetadata metadata;
    private Thread listenerThread;
    private boolean running = false;
    private final Object internalLock = new Object();

    public CouchChangeListener() {
    }

    public CouchChangeListener(CouchChangeDispatcher dispatcher, CouchHttpClient http, CouchDBConfiguration config, CouchManager couch, Serializer serializer) {
        this.dispatcher = dispatcher;
        this.http = http;
        this.config = config;
        this.couch = couch;
        this.serializer = serializer;
    }

    public void startup() throws CouchDBException {
        this.startup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(boolean wait) throws CouchDBException {
        this.metadata = this.couch.getDocument(new CouchDocRef(CHANGE_LISTENER_DOCID), ChangeListenerMetadata.class);
        if (this.metadata == null) {
            this.metadata = new ChangeListenerMetadata();
        }
        this.listenerThread = new Thread(this);
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
        if (wait) {
            Object object = this.internalLock;
            synchronized (object) {
                while (!this.running) {
                    this.logger.info("Waiting for change listener to startup...", new Object[0]);
                    try {
                        this.internalLock.wait(100L);
                    }
                    catch (InterruptedException e) {
                        this.logger.info("Interrupted...", new Object[0]);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws CouchDBException {
        Object object;
        if (this.listenerThread != null) {
            this.listenerThread.interrupt();
            while (this.listenerThread.isAlive()) {
                this.logger.info("Waiting for change-listener shutdown...", new Object[0]);
                object = this.internalLock;
                synchronized (object) {
                    try {
                        this.internalLock.wait(2000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
        if (this.metadata != null && this.metadata.getLastProcessedSequenceId() < 1) {
            this.couch.store(this.metadata, false);
        }
        this.running = false;
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CouchDocChangeDeserializer docDeserializer = new CouchDocChangeDeserializer();
        while (!Thread.interrupted()) {
            HttpGet get;
            try {
                String url = UrlUtils.buildUrl(this.config.getDatabaseUrl(), this.metadata.getUrlParameters(), CHANGES_SERVICE);
                get = new HttpGet(url);
            }
            catch (MalformedURLException e) {
                this.logger.error("Failed to construct changes URL for db: %s. Reason: %s", (Throwable)e, new Object[]{this.config.getDatabaseUrl(), e.getMessage()});
                break;
            }
            String encoding = null;
            try {
                HttpResponse response = this.http.executeHttpWithResponse((HttpRequestBase)get, "Failed to open changes stream.");
                if (response.getEntity() == null) {
                    this.logger.error("Changes stream did not return a response body.", new Object[0]);
                    break;
                }
                Header encodingHeader = response.getEntity().getContentEncoding();
                encoding = encodingHeader == null ? "UTF-8" : encodingHeader.getValue();
                InputStream stream = response.getEntity().getContent();
                this.running = true;
                Object object = this.internalLock;
                synchronized (object) {
                    this.internalLock.notifyAll();
                }
                CouchDocChangeList changes = (CouchDocChangeList)this.serializer.fromJson(stream, encoding, (Type)((Object)CouchDocChangeList.class), docDeserializer);
                for (CouchDocChange change : changes) {
                    if (change.getId().equals(CHANGE_LISTENER_DOCID)) continue;
                    this.metadata.setLastProcessedSequenceId(change.getSequence());
                    this.dispatcher.documentChanged(change);
                }
            }
            catch (CouchDBException e) {
                this.logger.error("Failed to read changes stream for db: %s. Reason: %s", (Throwable)e, new Object[]{this.config.getDatabaseUrl(), e.getMessage()});
                break;
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("Invalid content encoding for changes response: %s. Reason: %s", (Throwable)e, new Object[]{encoding, e.getMessage()});
                break;
            }
            catch (IOException e) {
                this.logger.error("Error reading changes response content. Reason: %s", (Throwable)e, new Object[]{e.getMessage()});
                break;
            }
            finally {
                this.http.cleanup((HttpRequestBase)get);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        Object object = this.internalLock;
        synchronized (object) {
            this.internalLock.notifyAll();
        }
    }

    static final class ChangeListenerMetadata
    extends AbstractCouchDocument {
        @SerializedName(value="last_seq")
        private int lastProcessedSequenceId;

        ChangeListenerMetadata() {
            this.setCouchDocId(CouchChangeListener.CHANGE_LISTENER_DOCID);
        }

        public Map<String, String> getUrlParameters() {
            HashMap<String, String> params = new HashMap<String, String>();
            if (this.lastProcessedSequenceId > 0) {
                params.put("since", Integer.toString(this.lastProcessedSequenceId));
            }
            return params;
        }

        int getLastProcessedSequenceId() {
            return this.lastProcessedSequenceId;
        }

        void setLastProcessedSequenceId(int lastProcessedSequenceId) {
            this.lastProcessedSequenceId = lastProcessedSequenceId;
        }
    }
}

